/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class ComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = ComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> ops, String string) {
        String string2 = ComponentDataFixUtils.createTextComponentJson(string);
        return new Dynamic<Object>(ops, ops.createString(string2));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> ops) {
        return new Dynamic<Object>(ops, ops.createString(EMPTY_CONTENTS));
    }

    private static String createTextComponentJson(String string) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", string);
        return GsonHelper.toStableString((JsonElement)jsonObject);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> ops, String key) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("translate", key);
        return new Dynamic<Object>(ops, ops.createString(GsonHelper.toStableString((JsonElement)jsonObject)));
    }

    public static <T> Dynamic<T> wrapLiteralStringAsComponent(Dynamic<T> dynamic) {
        return (Dynamic)((Object)DataFixUtils.orElse((Optional)dynamic.asString().map(string -> ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), string)).result(), dynamic));
    }

    public static Dynamic<?> rewriteFromLenient(Dynamic<?> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isEmpty()) {
            return dynamic;
        }
        String string = (String)optional.get();
        if (string.isEmpty() || string.equals("null")) {
            return ComponentDataFixUtils.createEmptyComponent(dynamic.getOps());
        }
        char c = string.charAt(0);
        char d = string.charAt(string.length() - 1);
        if (c == '\"' && d == '\"' || c == '{' && d == '}' || c == '[' && d == ']') {
            try {
                JsonElement jsonElement = JsonParser.parseString((String)string);
                if (jsonElement.isJsonPrimitive()) {
                    return ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), jsonElement.getAsString());
                }
                return dynamic.createString(GsonHelper.toStableString(jsonElement));
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return ComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), string);
    }

    public static Optional<String> extractTranslationString(String json) {
        try {
            JsonObject jsonObject;
            JsonElement jsonElement2;
            JsonElement jsonElement = JsonParser.parseString((String)json);
            if (jsonElement.isJsonObject() && (jsonElement2 = (jsonObject = jsonElement.getAsJsonObject()).get("translate")) != null && jsonElement2.isJsonPrimitive()) {
                return Optional.of(jsonElement2.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

