/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class EffectDurationFix
extends DataFix {
    private static final Set<String> POTION_ITEMS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");

    public EffectDurationFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        Type type = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        OpticFinder opticFinder2 = type.findField("tag");
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("EffectDurationEntity", schema.getType(References.ENTITY), entityTyped -> entityTyped.update(DSL.remainderFinder(), this::updateEntity)), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("EffectDurationPlayer", schema.getType(References.PLAYER), playerTyped -> playerTyped.update(DSL.remainderFinder(), this::updateEntity)), this.fixTypeEverywhereTyped("EffectDurationItem", type, itemStackTyped -> {
            Optional optional;
            if (itemStackTyped.getOptional(opticFinder).filter(pair -> POTION_ITEMS.contains(pair.getSecond())).isPresent() && (optional = itemStackTyped.getOptionalTyped(opticFinder2)).isPresent()) {
                Dynamic dynamic = (Dynamic)((Object)((Object)((Typed)optional.get()).get(DSL.remainderFinder())));
                Typed typed = ((Typed)optional.get()).set(DSL.remainderFinder(), dynamic.update("CustomPotionEffects", this::fix));
                return itemStackTyped.set(opticFinder2, typed);
            }
            return itemStackTyped;
        })});
    }

    private Dynamic<?> fixEffect(Dynamic<?> effectDynamic) {
        return effectDynamic.update("FactorCalculationData", factorCalculationDataDynamic -> {
            int i = factorCalculationDataDynamic.get("effect_changed_timestamp").asInt(-1);
            factorCalculationDataDynamic = factorCalculationDataDynamic.remove("effect_changed_timestamp");
            int j = effectDynamic.get("Duration").asInt(-1);
            int k = i - j;
            return factorCalculationDataDynamic.set("ticks_active", factorCalculationDataDynamic.createInt(k));
        });
    }

    private Dynamic<?> fix(Dynamic<?> effectsDynamic) {
        return effectsDynamic.createList(effectsDynamic.asStream().map(this::fixEffect));
    }

    private Dynamic<?> updateEntity(Dynamic<?> entityDynamic) {
        entityDynamic = entityDynamic.update("Effects", this::fix);
        entityDynamic = entityDynamic.update("ActiveEffects", this::fix);
        entityDynamic = entityDynamic.update("CustomPotionEffects", this::fix);
        return entityDynamic;
    }
}

