/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int HIDE_ENCHANTMENTS = 1;
    private static final int HIDE_MODIFIERS = 2;
    private static final int HIDE_UNBREAKABLE = 4;
    private static final int HIDE_CAN_DESTROY = 8;
    private static final int HIDE_CAN_PLACE = 16;
    private static final int HIDE_ADDITIONAL = 32;
    private static final int HIDE_DYE = 64;
    private static final int HIDE_UPGRADES = 128;
    private static final Set<String> POTION_HOLDER_IDS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> BUCKETED_MOB_IDS = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> BUCKETED_MOB_TAGS = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> BOOLEAN_BLOCK_STATE_PROPERTIES = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter PROPERTY_SPLITTER = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    private static void fixItemStack(ItemStackData data, Dynamic<?> dynamic3) {
        int i = data.removeTag("HideFlags").asInt(0);
        data.moveTagToComponent("Damage", "minecraft:damage", dynamic3.createInt(0));
        data.moveTagToComponent("RepairCost", "minecraft:repair_cost", dynamic3.createInt(0));
        data.moveTagToComponent("CustomModelData", "minecraft:custom_model_data");
        data.removeTag("BlockStateTag").result().ifPresent(blockStateTagDynamic -> data.setComponent("minecraft:block_state", ItemStackComponentizationFix.fixBlockStateTag(blockStateTagDynamic)));
        data.moveTagToComponent("EntityTag", "minecraft:entity_data");
        data.fixSubTag("BlockEntityTag", false, blockEntityTagDynamic -> {
            String string = NamespacedSchema.ensureNamespaced(blockEntityTagDynamic.get("id").asString(""));
            Dynamic dynamic = (blockEntityTagDynamic = ItemStackComponentizationFix.fixBlockEntityTag(data, blockEntityTagDynamic, string)).remove("id");
            if (dynamic.equals((Object)blockEntityTagDynamic.emptyMap())) {
                return dynamic;
            }
            return blockEntityTagDynamic;
        });
        data.moveTagToComponent("BlockEntityTag", "minecraft:block_entity_data");
        if (data.removeTag("Unbreakable").asBoolean(false)) {
            Dynamic dynamic22 = dynamic3.emptyMap();
            if ((i & 4) != 0) {
                dynamic22 = dynamic22.set("show_in_tooltip", dynamic3.createBoolean(false));
            }
            data.setComponent("minecraft:unbreakable", dynamic22);
        }
        ItemStackComponentizationFix.fixEnchantments(data, dynamic3, "Enchantments", "minecraft:enchantments", (i & 1) != 0);
        if (data.is("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.fixEnchantments(data, dynamic3, "StoredEnchantments", "minecraft:stored_enchantments", (i & 0x20) != 0);
        }
        data.fixSubTag("display", false, displayDynamic -> ItemStackComponentizationFix.fixDisplay(data, displayDynamic, i));
        ItemStackComponentizationFix.fixAdventureModeChecks(data, dynamic3, i);
        ItemStackComponentizationFix.fixAttributeModifiers(data, dynamic3, i);
        Optional optional = data.removeTag("Trim").result();
        if (optional.isPresent()) {
            Dynamic dynamic32 = (Dynamic)((Object)optional.get());
            if ((i & 0x80) != 0) {
                dynamic32 = dynamic32.set("show_in_tooltip", dynamic32.createBoolean(false));
            }
            data.setComponent("minecraft:trim", dynamic32);
        }
        if ((i & 0x20) != 0) {
            data.setComponent("minecraft:hide_additional_tooltip", dynamic3.emptyMap());
        }
        if (data.is("minecraft:crossbow")) {
            data.removeTag("Charged");
            data.moveTagToComponent("ChargedProjectiles", "minecraft:charged_projectiles", dynamic3.createList(Stream.empty()));
        }
        if (data.is("minecraft:bundle")) {
            data.moveTagToComponent("Items", "minecraft:bundle_contents", dynamic3.createList(Stream.empty()));
        }
        if (data.is("minecraft:filled_map")) {
            data.moveTagToComponent("map", "minecraft:map_id");
            Map<Dynamic, Dynamic> map = data.removeTag("Decorations").asStream().map(ItemStackComponentizationFix::fixMapDecoration).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (dynamic, dynamic2) -> dynamic));
            if (!map.isEmpty()) {
                data.setComponent("minecraft:map_decorations", dynamic3.createMap(map));
            }
        }
        if (data.is(POTION_HOLDER_IDS)) {
            ItemStackComponentizationFix.fixPotionContents(data, dynamic3);
        }
        if (data.is("minecraft:writable_book")) {
            ItemStackComponentizationFix.fixWritableBook(data, dynamic3);
        }
        if (data.is("minecraft:written_book")) {
            ItemStackComponentizationFix.fixWrittenBook(data, dynamic3);
        }
        if (data.is("minecraft:suspicious_stew")) {
            data.moveTagToComponent("effects", "minecraft:suspicious_stew_effects");
        }
        if (data.is("minecraft:debug_stick")) {
            data.moveTagToComponent("DebugProperty", "minecraft:debug_stick_state");
        }
        if (data.is(BUCKETED_MOB_IDS)) {
            ItemStackComponentizationFix.fixBucketedMobData(data, dynamic3);
        }
        if (data.is("minecraft:goat_horn")) {
            data.moveTagToComponent("instrument", "minecraft:instrument");
        }
        if (data.is("minecraft:knowledge_book")) {
            data.moveTagToComponent("Recipes", "minecraft:recipes");
        }
        if (data.is("minecraft:compass")) {
            ItemStackComponentizationFix.fixLodestoneTracker(data, dynamic3);
        }
        if (data.is("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.fixFireworkRocket(data);
        }
        if (data.is("minecraft:firework_star")) {
            ItemStackComponentizationFix.fixFireworkStar(data);
        }
        if (data.is("minecraft:player_head")) {
            data.removeTag("SkullOwner").result().ifPresent(skullOwnerDynamic -> data.setComponent("minecraft:profile", ItemStackComponentizationFix.fixProfile(skullOwnerDynamic)));
        }
    }

    private static Dynamic<?> fixBlockStateTag(Dynamic<?> dynamic) {
        return (Dynamic)((Object)DataFixUtils.orElse(dynamic.asMapOpt().result().map(stream -> stream.collect(Collectors.toMap(Pair::getFirst, pair -> {
            Optional optional;
            String string = ((Dynamic)((Object)((Object)((Object)pair.getFirst())))).asString("");
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)pair.getSecond())));
            if (BOOLEAN_BLOCK_STATE_PROPERTIES.contains(string) && (optional = dynamic.asBoolean().result()).isPresent()) {
                return dynamic.createString(String.valueOf(optional.get()));
            }
            Optional optional2 = dynamic.asNumber().result();
            if (optional2.isPresent()) {
                return dynamic.createString(((Number)optional2.get()).toString());
            }
            return dynamic;
        }))).map(arg_0 -> dynamic.createMap(arg_0)), dynamic));
    }

    private static Dynamic<?> fixDisplay(ItemStackData data, Dynamic<?> dynamic, int hideFlags) {
        Optional optional2;
        boolean bl;
        data.setComponent("minecraft:custom_name", dynamic.get("Name"));
        data.setComponent("minecraft:lore", dynamic.get("Lore"));
        Optional<Integer> optional = dynamic.get("color").asNumber().result().map(Number::intValue);
        boolean bl2 = bl = (hideFlags & 0x40) != 0;
        if (optional.isPresent() || bl) {
            Dynamic dynamic2 = dynamic.emptyMap().set("rgb", dynamic.createInt(optional.orElse(10511680)));
            if (bl) {
                dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent("minecraft:dyed_color", dynamic2);
        }
        if ((optional2 = dynamic.get("LocName").asString().result()).isPresent()) {
            data.setComponent("minecraft:item_name", ComponentDataFixUtils.createTranslatableComponent(dynamic.getOps(), (String)optional2.get()));
        }
        if (data.is("minecraft:filled_map")) {
            data.setComponent("minecraft:map_color", dynamic.get("MapColor"));
            dynamic = dynamic.remove("MapColor");
        }
        return dynamic.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static <T> Dynamic<T> fixBlockEntityTag(ItemStackData data, Dynamic<T> dynamic, String blockEntityId) {
        data.setComponent("minecraft:lock", dynamic.get("Lock"));
        dynamic = dynamic.remove("Lock");
        Optional optional = dynamic.get("LootTable").result();
        if (optional.isPresent()) {
            Dynamic dynamic2 = dynamic.emptyMap().set("loot_table", (Dynamic)((Object)optional.get()));
            long l = dynamic.get("LootTableSeed").asLong(0L);
            if (l != 0L) {
                dynamic2 = dynamic2.set("seed", dynamic.createLong(l));
            }
            data.setComponent("minecraft:container_loot", dynamic2);
            dynamic = dynamic.remove("LootTable").remove("LootTableSeed");
        }
        return switch (blockEntityId) {
            case "minecraft:skull" -> {
                data.setComponent("minecraft:note_block_sound", dynamic.get("note_block_sound"));
                yield dynamic.remove("note_block_sound");
            }
            case "minecraft:decorated_pot" -> {
                data.setComponent("minecraft:pot_decorations", dynamic.get("sherds"));
                Optional optional2 = dynamic.get("item").result();
                if (optional2.isPresent()) {
                    data.setComponent("minecraft:container", dynamic.createList(Stream.of(dynamic.emptyMap().set("slot", dynamic.createInt(0)).set("item", (Dynamic)((Object)optional2.get())))));
                }
                yield dynamic.remove("sherds").remove("item");
            }
            case "minecraft:banner" -> {
                data.setComponent("minecraft:banner_patterns", dynamic.get("patterns"));
                Optional optional3 = dynamic.get("Base").asNumber().result();
                if (optional3.isPresent()) {
                    data.setComponent("minecraft:base_color", dynamic.createString(BannerPatternFormatFix.fixColor(((Number)optional3.get()).intValue())));
                }
                yield dynamic.remove("patterns").remove("Base");
            }
            case "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter" -> {
                List list = dynamic.get("Items").asList(itemsDynamic -> itemsDynamic.emptyMap().set("slot", itemsDynamic.createInt(itemsDynamic.get("Slot").asByte((byte)0) & 0xFF)).set("item", itemsDynamic.remove("Slot")));
                if (!list.isEmpty()) {
                    data.setComponent("minecraft:container", dynamic.createList(list.stream()));
                }
                yield dynamic.remove("Items");
            }
            case "minecraft:beehive" -> {
                data.setComponent("minecraft:bees", dynamic.get("bees"));
                yield dynamic.remove("bees");
            }
            default -> dynamic;
        };
    }

    private static void fixEnchantments(ItemStackData data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        OptionalDynamic<?> optionalDynamic = data.removeTag(nbtKey);
        List list = optionalDynamic.asList(Function.identity()).stream().flatMap(enchantmentsDynamic -> ItemStackComponentizationFix.parseEnchantment(enchantmentsDynamic).stream()).toList();
        if (!list.isEmpty() || hideInTooltip) {
            Dynamic dynamic2 = dynamic.emptyMap();
            Dynamic dynamic3 = dynamic.emptyMap();
            for (Pair pair : list) {
                dynamic3 = dynamic3.set((String)pair.getFirst(), dynamic.createInt((Integer)pair.getSecond()));
            }
            dynamic2 = dynamic2.set("levels", dynamic3);
            if (hideInTooltip) {
                dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
            }
            data.setComponent(componentId, dynamic2);
        }
        if (optionalDynamic.result().isPresent() && list.isEmpty()) {
            data.setComponent("minecraft:enchantment_glint_override", dynamic.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> parseEnchantment(Dynamic<?> dynamic) {
        return dynamic.get("id").asString().apply2stable((enchantmentId, level) -> Pair.of((Object)enchantmentId, (Object)Mth.clamp(level.intValue(), 0, 255)), dynamic.get("lvl").asNumber()).result();
    }

    private static void fixAdventureModeChecks(ItemStackData data, Dynamic<?> dynamic, int hideFlags) {
        ItemStackComponentizationFix.fixBlockStatePredicates(data, dynamic, "CanDestroy", "minecraft:can_break", (hideFlags & 8) != 0);
        ItemStackComponentizationFix.fixBlockStatePredicates(data, dynamic, "CanPlaceOn", "minecraft:can_place_on", (hideFlags & 0x10) != 0);
    }

    private static void fixBlockStatePredicates(ItemStackData data, Dynamic<?> dynamic, String nbtKey, String componentId, boolean hideInTooltip) {
        Optional optional = data.removeTag(nbtKey).result();
        if (optional.isEmpty()) {
            return;
        }
        Dynamic dynamic2 = dynamic.emptyMap().set("predicates", dynamic.createList(((Dynamic)((Object)optional.get())).asStream().map(predicatesDynamic -> (Dynamic)((Object)((Object)DataFixUtils.orElse((Optional)predicatesDynamic.asString().map(string -> ItemStackComponentizationFix.fixBlockStatePredicate(predicatesDynamic, string)).result(), (Object)predicatesDynamic))))));
        if (hideInTooltip) {
            dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
        }
        data.setComponent(componentId, dynamic2);
    }

    private static Dynamic<?> fixBlockStatePredicate(Dynamic<?> dynamic, String listAsString) {
        int i = listAsString.indexOf(91);
        int j = listAsString.indexOf(123);
        int k = listAsString.length();
        if (i != -1) {
            k = i;
        }
        if (j != -1) {
            k = Math.min(k, j);
        }
        String string = listAsString.substring(0, k);
        Dynamic dynamic2 = dynamic.emptyMap().set("blocks", dynamic.createString(string.trim()));
        int l = listAsString.indexOf(93);
        if (i != -1 && l != -1) {
            Dynamic dynamic3 = dynamic.emptyMap();
            Iterable iterable = PROPERTY_SPLITTER.split((CharSequence)listAsString.substring(i + 1, l));
            for (String string2 : iterable) {
                int m = string2.indexOf(61);
                if (m == -1) continue;
                String string3 = string2.substring(0, m).trim();
                String string4 = string2.substring(m + 1).trim();
                dynamic3 = dynamic3.set(string3, dynamic.createString(string4));
            }
            dynamic2 = dynamic2.set("state", dynamic3);
        }
        int n = listAsString.indexOf(125);
        if (j != -1 && n != -1) {
            dynamic2 = dynamic2.set("nbt", dynamic.createString(listAsString.substring(j, n + 1)));
        }
        return dynamic2;
    }

    private static void fixAttributeModifiers(ItemStackData data, Dynamic<?> dynamic, int hideFlags) {
        OptionalDynamic<?> optionalDynamic = data.removeTag("AttributeModifiers");
        if (optionalDynamic.result().isEmpty()) {
            return;
        }
        boolean bl = (hideFlags & 2) != 0;
        List list = optionalDynamic.asList(ItemStackComponentizationFix::fixAttributeModifier);
        Dynamic dynamic2 = dynamic.emptyMap().set("modifiers", dynamic.createList(list.stream()));
        if (bl) {
            dynamic2 = dynamic2.set("show_in_tooltip", dynamic.createBoolean(false));
        }
        data.setComponent("minecraft:attribute_modifiers", dynamic2);
    }

    private static Dynamic<?> fixAttributeModifier(Dynamic<?> dynamic) {
        Dynamic<Object> dynamic2 = dynamic.emptyMap().set("name", dynamic.createString("")).set("amount", dynamic.createDouble(0.0)).set("operation", dynamic.createString("add_value"));
        dynamic2 = Dynamic.copyField(dynamic, "AttributeName", dynamic2, "type");
        dynamic2 = Dynamic.copyField(dynamic, "Slot", dynamic2, "slot");
        dynamic2 = Dynamic.copyField(dynamic, "UUID", dynamic2, "uuid");
        dynamic2 = Dynamic.copyField(dynamic, "Name", dynamic2, "name");
        dynamic2 = Dynamic.copyField(dynamic, "Amount", dynamic2, "amount");
        dynamic2 = Dynamic.copyAndFixField(dynamic, "Operation", dynamic2, "operation", operationDynamic -> operationDynamic.createString(switch (operationDynamic.asInt(0)) {
            default -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
        }));
        return dynamic2;
    }

    private static Pair<Dynamic<?>, Dynamic<?>> fixMapDecoration(Dynamic<?> dynamic) {
        Dynamic dynamic2 = (Dynamic)((Object)DataFixUtils.orElseGet((Optional)dynamic.get("id").result(), () -> dynamic.createString("")));
        Dynamic dynamic3 = dynamic.emptyMap().set("type", dynamic.createString(ItemStackComponentizationFix.fixMapDecorationType(dynamic.get("type").asInt(0)))).set("x", dynamic.createDouble(dynamic.get("x").asDouble(0.0))).set("z", dynamic.createDouble(dynamic.get("z").asDouble(0.0))).set("rotation", dynamic.createFloat((float)dynamic.get("rot").asDouble(0.0)));
        return Pair.of((Object)((Object)dynamic2), dynamic3);
    }

    private static String fixMapDecorationType(int index) {
        return switch (index) {
            default -> "player";
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
        };
    }

    private static void fixPotionContents(ItemStackData data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = dynamic.emptyMap();
        Optional<String> optional = data.removeTag("Potion").asString().result().filter(potionId -> !potionId.equals("minecraft:empty"));
        if (optional.isPresent()) {
            dynamic2 = dynamic2.set("potion", dynamic.createString(optional.get()));
        }
        dynamic2 = data.moveTagInto("CustomPotionColor", dynamic2, "custom_color");
        if (!(dynamic2 = data.moveTagInto("custom_potion_effects", dynamic2, "custom_effects")).equals((Object)dynamic.emptyMap())) {
            data.setComponent("minecraft:potion_contents", dynamic2);
        }
    }

    private static void fixWritableBook(ItemStackData data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.fixBookPages(data, dynamic);
        if (dynamic2 != null) {
            data.setComponent("minecraft:writable_book_content", dynamic.emptyMap().set("pages", dynamic2));
        }
    }

    private static void fixWrittenBook(ItemStackData data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.fixBookPages(data, dynamic);
        String string = data.removeTag("title").asString("");
        Optional optional = data.removeTag("filtered_title").asString().result();
        Dynamic<Object> dynamic3 = dynamic.emptyMap();
        dynamic3 = dynamic3.set("title", ItemStackComponentizationFix.createFilteredText(dynamic, string, optional));
        dynamic3 = data.moveTagInto("author", dynamic3, "author");
        dynamic3 = data.moveTagInto("resolved", dynamic3, "resolved");
        dynamic3 = data.moveTagInto("generation", dynamic3, "generation");
        if (dynamic2 != null) {
            dynamic3 = dynamic3.set("pages", dynamic2);
        }
        data.setComponent("minecraft:written_book_content", dynamic3);
    }

    @Nullable
    private static Dynamic<?> fixBookPages(ItemStackData data, Dynamic<?> dynamic) {
        List list = data.removeTag("pages").asList(pagesDynamic -> pagesDynamic.asString(""));
        Map map = data.removeTag("filtered_pages").asMap(filteredPagesKeyDynamic -> filteredPagesKeyDynamic.asString("0"), filteredPagesValueDynamic -> filteredPagesValueDynamic.asString(""));
        if (list.isEmpty()) {
            return null;
        }
        ArrayList list2 = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            String string2 = (String)map.get(String.valueOf(i));
            list2.add(ItemStackComponentizationFix.createFilteredText(dynamic, string, Optional.ofNullable(string2)));
        }
        return dynamic.createList(list2.stream());
    }

    private static Dynamic<?> createFilteredText(Dynamic<?> dynamic, String unfiltered, Optional<String> filtered) {
        Dynamic dynamic2 = dynamic.emptyMap().set("raw", dynamic.createString(unfiltered));
        if (filtered.isPresent()) {
            dynamic2 = dynamic2.set("filtered", dynamic.createString(filtered.get()));
        }
        return dynamic2;
    }

    private static void fixBucketedMobData(ItemStackData data, Dynamic<?> dynamic) {
        Dynamic<?> dynamic2 = dynamic.emptyMap();
        for (String string : BUCKETED_MOB_TAGS) {
            dynamic2 = data.moveTagInto(string, dynamic2, string);
        }
        if (!dynamic2.equals((Object)dynamic.emptyMap())) {
            data.setComponent("minecraft:bucket_entity_data", dynamic2);
        }
    }

    private static void fixLodestoneTracker(ItemStackData data, Dynamic<?> dynamic) {
        Optional optional = data.removeTag("LodestonePos").result();
        Optional optional2 = data.removeTag("LodestoneDimension").result();
        if (optional.isEmpty() && optional2.isEmpty()) {
            return;
        }
        boolean bl = data.removeTag("LodestoneTracked").asBoolean(true);
        Dynamic dynamic2 = dynamic.emptyMap();
        if (optional.isPresent() && optional2.isPresent()) {
            dynamic2 = dynamic2.set("target", dynamic.emptyMap().set("pos", (Dynamic)((Object)optional.get())).set("dimension", (Dynamic)((Object)optional2.get())));
        }
        if (!bl) {
            dynamic2 = dynamic2.set("tracked", dynamic.createBoolean(false));
        }
        data.setComponent("minecraft:lodestone_tracker", dynamic2);
    }

    private static void fixFireworkStar(ItemStackData data) {
        data.fixSubTag("Explosion", true, explosionDynamic -> {
            data.setComponent("minecraft:firework_explosion", ItemStackComponentizationFix.fixFireworkExplosion(explosionDynamic));
            return explosionDynamic.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void fixFireworkRocket(ItemStackData data) {
        data.fixSubTag("Fireworks", true, fireworksDynamic -> {
            Stream<Dynamic> stream = fireworksDynamic.get("Explosions").asStream().map(ItemStackComponentizationFix::fixFireworkExplosion);
            int i = fireworksDynamic.get("Flight").asInt(0);
            data.setComponent("minecraft:fireworks", fireworksDynamic.emptyMap().set("explosions", fireworksDynamic.createList(stream)).set("flight_duration", fireworksDynamic.createByte((byte)i)));
            return fireworksDynamic.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> fixFireworkExplosion(Dynamic<?> dynamic) {
        dynamic = dynamic.set("shape", dynamic.createString(switch (dynamic.get("Type").asInt(0)) {
            default -> "small_ball";
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
        })).remove("Type");
        dynamic = dynamic.renameField("Colors", "colors");
        dynamic = dynamic.renameField("FadeColors", "fade_colors");
        dynamic = dynamic.renameField("Trail", "has_trail");
        dynamic = dynamic.renameField("Flicker", "has_twinkle");
        return dynamic;
    }

    public static Dynamic<?> fixProfile(Dynamic<?> dynamic) {
        Optional optional = dynamic.asString().result();
        if (optional.isPresent()) {
            if (ItemStackComponentizationFix.isValidPlayerName((String)optional.get())) {
                return dynamic.emptyMap().set("name", dynamic.createString((String)optional.get()));
            }
            return dynamic.emptyMap();
        }
        String string = dynamic.get("Name").asString("");
        Optional optional2 = dynamic.get("Id").result();
        Dynamic<?> dynamic2 = ItemStackComponentizationFix.fixProfileProperties(dynamic.get("Properties"));
        Dynamic dynamic3 = dynamic.emptyMap();
        if (ItemStackComponentizationFix.isValidPlayerName(string)) {
            dynamic3 = dynamic3.set("name", dynamic.createString(string));
        }
        if (optional2.isPresent()) {
            dynamic3 = dynamic3.set("id", (Dynamic)((Object)optional2.get()));
        }
        if (dynamic2 != null) {
            dynamic3 = dynamic3.set("properties", dynamic2);
        }
        return dynamic3;
    }

    private static boolean isValidPlayerName(String username) {
        if (username.length() > 16) {
            return false;
        }
        return username.chars().filter(c -> c <= 32 || c >= 127).findAny().isEmpty();
    }

    @Nullable
    private static Dynamic<?> fixProfileProperties(OptionalDynamic<?> propertiesDynamic) {
        Map map = propertiesDynamic.asMap(dynamic -> dynamic.asString(""), dynamic2 -> dynamic2.asList(dynamic -> {
            String string = dynamic.get("Value").asString("");
            Optional optional = dynamic.get("Signature").asString().result();
            return Pair.of((Object)string, (Object)optional);
        }));
        if (map.isEmpty()) {
            return null;
        }
        return propertiesDynamic.createList(map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(pair -> {
            Dynamic dynamic = propertiesDynamic.emptyMap().set("name", propertiesDynamic.createString((String)entry.getKey())).set("value", propertiesDynamic.createString((String)pair.getFirst()));
            Optional optional = (Optional)pair.getSecond();
            if (optional.isPresent()) {
                return dynamic.set("signature", propertiesDynamic.createString((String)optional.get()));
            }
            return dynamic;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(References.ITEM_STACK), this.getOutputSchema().getType(References.ITEM_STACK), dynamic -> {
            Optional<Dynamic> optional = ItemStackData.read(dynamic).map(data -> {
                ItemStackComponentizationFix.fixItemStack(data, data.tag);
                return data.write();
            });
            return (Dynamic)((Object)((Object)DataFixUtils.orElse(optional, (Object)dynamic)));
        });
    }

    static class ItemStackData {
        private final String item;
        private final int count;
        private Dynamic<?> components;
        private final Dynamic<?> remainder;
        Dynamic<?> tag;

        private ItemStackData(String itemId, int count, Dynamic<?> dynamic) {
            this.item = NamespacedSchema.ensureNamespaced(itemId);
            this.count = count;
            this.components = dynamic.emptyMap();
            this.tag = dynamic.get("tag").orElseEmptyMap();
            this.remainder = dynamic.remove("tag");
        }

        public static Optional<ItemStackData> read(Dynamic<?> dynamic) {
            return dynamic.get("id").asString().apply2stable((itemId, count) -> new ItemStackData((String)itemId, count.intValue(), dynamic.remove("id").remove("Count")), dynamic.get("Count").asNumber()).result();
        }

        public OptionalDynamic<?> removeTag(String key) {
            OptionalDynamic<?> optionalDynamic = this.tag.get(key);
            this.tag = this.tag.remove(key);
            return optionalDynamic;
        }

        public void setComponent(String key, Dynamic<?> value) {
            this.components = this.components.set(key, value);
        }

        public void setComponent(String key, OptionalDynamic<?> optionalValue) {
            optionalValue.result().ifPresent(value -> {
                this.components = this.components.set(key, (Dynamic<?>)((Object)value));
            });
        }

        public Dynamic<?> moveTagInto(String nbtKey, Dynamic<?> components, String componentId) {
            Optional optional = this.removeTag(nbtKey).result();
            if (optional.isPresent()) {
                return components.set(componentId, (Dynamic)((Object)optional.get()));
            }
            return components;
        }

        public void moveTagToComponent(String nbtKey, String componentId, Dynamic<?> defaultValue) {
            Optional optional = this.removeTag(nbtKey).result();
            if (optional.isPresent() && !((Dynamic)((Object)optional.get())).equals(defaultValue)) {
                this.setComponent(componentId, (Dynamic)((Object)optional.get()));
            }
        }

        public void moveTagToComponent(String nbtKey, String componentId) {
            this.removeTag(nbtKey).result().ifPresent(nbt -> this.setComponent(componentId, (Dynamic<?>)((Object)nbt)));
        }

        public void fixSubTag(String nbtKey, boolean removeIfEmpty, UnaryOperator<Dynamic<?>> fixer) {
            OptionalDynamic<?> optionalDynamic = this.tag.get(nbtKey);
            if (removeIfEmpty && optionalDynamic.result().isEmpty()) {
                return;
            }
            Dynamic dynamic = optionalDynamic.orElseEmptyMap();
            this.tag = (dynamic = (Dynamic)((Object)fixer.apply(dynamic))).equals((Object)dynamic.emptyMap()) ? this.tag.remove(nbtKey) : this.tag.set(nbtKey, dynamic);
        }

        public Dynamic<?> write() {
            Dynamic dynamic = this.tag.emptyMap().set("id", this.tag.createString(this.item)).set("count", this.tag.createInt(this.count));
            if (!this.tag.equals((Object)this.tag.emptyMap())) {
                this.components = this.components.set("minecraft:custom_data", this.tag);
            }
            if (!this.components.equals((Object)this.tag.emptyMap())) {
                dynamic = dynamic.set("components", this.components);
            }
            return ItemStackData.mergeRemainder(dynamic, this.remainder);
        }

        private static <T> Dynamic<T> mergeRemainder(Dynamic<T> data, Dynamic<?> leftoverNbt) {
            DynamicOps dynamicOps = data.getOps();
            return dynamicOps.getMap(data.getValue()).flatMap(mapLike -> dynamicOps.mergeToMap(leftoverNbt.convert(dynamicOps).getValue(), mapLike)).map(object -> new Dynamic<Object>(dynamicOps, object)).result().orElse(data);
        }

        public boolean is(String itemId) {
            return this.item.equals(itemId);
        }

        public boolean is(Set<String> itemIds) {
            return itemIds.contains(this.item);
        }

        public boolean hasComponent(String componentId) {
            return this.components.get(componentId).result().isPresent();
        }
    }
}

