/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.AbstractUUIDFix;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class LevelUUIDFix
extends AbstractUUIDFix {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LevelUUIDFix(Schema outputSchema) {
        super(outputSchema, References.LEVEL);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelUUIDFix", this.getInputSchema().getType(this.typeReference), levelTyped -> levelTyped.updateTyped(DSL.remainderFinder(), levelTyped2 -> levelTyped2.update(DSL.remainderFinder(), levelDynamic -> {
            levelDynamic = this.updateCustomBossEvents((Dynamic<?>)((Object)((Object)((Object)levelDynamic))));
            levelDynamic = this.updateDragonFight((Dynamic<?>)((Object)((Object)((Object)levelDynamic))));
            levelDynamic = this.updateWanderingTrader((Dynamic<?>)((Object)((Object)((Object)levelDynamic))));
            return levelDynamic;
        })));
    }

    private Dynamic<?> updateWanderingTrader(Dynamic<?> levelDynamic) {
        return LevelUUIDFix.replaceUUIDString(levelDynamic, "WanderingTraderId", "WanderingTraderId").orElse(levelDynamic);
    }

    private Dynamic<?> updateDragonFight(Dynamic<?> levelDynamic) {
        return levelDynamic.update("DimensionData", dimensionDataDynamic -> dimensionDataDynamic.updateMapValues(entry -> entry.mapSecond(dimensionDataValueDynamic -> dimensionDataValueDynamic.update("DragonFight", dragonFightDynamic -> LevelUUIDFix.replaceUUIDLeastMost(dragonFightDynamic, "DragonUUID", "Dragon").orElse((Dynamic<?>)((Object)((Object)((Object)((Object)dragonFightDynamic)))))))));
    }

    private Dynamic<?> updateCustomBossEvents(Dynamic<?> levelDynamic) {
        return levelDynamic.update("CustomBossEvents", bossbarsDynamic -> bossbarsDynamic.updateMapValues(entry -> entry.mapSecond(bossbarDynamic -> bossbarDynamic.update("Players", playersDynamic -> bossbarDynamic.createList(playersDynamic.asStream().map(playerDynamic -> LevelUUIDFix.createUUIDFromML(playerDynamic).orElseGet(() -> {
            LOGGER.warn("CustomBossEvents contains invalid UUIDs.");
            return playerDynamic;
        })))))));
    }
}

