/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import net.minecraft.util.parsing.packrat.commands.ResourceSuggestion;
import net.minecraft.util.parsing.packrat.commands.StringReaderParserState;

public record Grammar<T>(Dictionary<StringReader> rules, Atom<T> top) {
    public Optional<T> parse(ParseState<StringReader> state) {
        return state.parseTopRule(this.top);
    }

    public T parseForCommands(StringReader reader) throws CommandSyntaxException {
        Object r;
        ErrorCollector.LongestOnly<StringReader> longestOnly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringReaderParserState = new StringReaderParserState(this.rules(), longestOnly, reader);
        Optional<T> optional = this.parse(stringReaderParserState);
        if (optional.isPresent()) {
            return optional.get();
        }
        List list = longestOnly.entries().stream().mapMulti((error, consumer) -> {
            Object object = error.reason();
            if (object instanceof Exception) {
                Exception exception = (Exception)object;
                consumer.accept(exception);
            }
        }).toList();
        for (Exception exception : list) {
            if (!(exception instanceof CommandSyntaxException)) continue;
            CommandSyntaxException commandSyntaxException = (CommandSyntaxException)exception;
            throw commandSyntaxException;
        }
        if (list.size() == 1 && (r = list.get(0)) instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)r;
            throw runtimeException;
        }
        throw new IllegalStateException("Failed to parse: " + longestOnly.entries().stream().map(ErrorEntry::toString).collect(Collectors.joining(", ")));
    }

    public CompletableFuture<Suggestions> parseForSuggestions(SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ErrorCollector.LongestOnly<StringReader> longestOnly = new ErrorCollector.LongestOnly<StringReader>();
        StringReaderParserState stringReaderParserState = new StringReaderParserState(this.rules(), longestOnly, stringReader);
        this.parse(stringReaderParserState);
        List<ErrorEntry<StringReader>> list = longestOnly.entries();
        if (list.isEmpty()) {
            return builder.buildFuture();
        }
        SuggestionsBuilder suggestionsBuilder = builder.createOffset(longestOnly.cursor());
        for (ErrorEntry<StringReader> errorEntry : list) {
            SuggestionSupplier<StringReader> suggestionSupplier = errorEntry.suggestions();
            if (suggestionSupplier instanceof ResourceSuggestion) {
                ResourceSuggestion resourceSuggestion = (ResourceSuggestion)suggestionSupplier;
                SharedSuggestionProvider.suggestResource(resourceSuggestion.possibleResources(), suggestionsBuilder);
                continue;
            }
            SharedSuggestionProvider.suggest(errorEntry.suggestions().possibleValues(stringReaderParserState), suggestionsBuilder);
        }
        return suggestionsBuilder.buildFuture();
    }
}

