/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.jtracy.Plot;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import org.slf4j.Logger;

public class TracyZoneFiller
implements ProfilerFiller {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 5);
    private final List<Zone> activeZones = new ArrayList<Zone>();
    private final Map<String, PlotAndValue> plots = new HashMap<String, PlotAndValue>();
    private final String name = Thread.currentThread().getName();

    @Override
    @Override
    public void startTick() {
    }

    @Override
    @Override
    public void endTick() {
        for (PlotAndValue plotAndValue : this.plots.values()) {
            plotAndValue.set(0);
        }
    }

    @Override
    @Override
    public void push(String location) {
        Optional optional;
        String string = "";
        String string2 = "";
        int i = 0;
        if (SharedConstants.IS_RUNNING_IN_IDE && (optional = STACK_WALKER.walk(stream -> stream.filter(frame -> frame.getDeclaringClass() != TracyZoneFiller.class && frame.getDeclaringClass() != ProfilerFiller.CombinedProfileFiller.class).findFirst())).isPresent()) {
            StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)optional.get();
            string = stackFrame.getMethodName();
            string2 = stackFrame.getFileName();
            i = stackFrame.getLineNumber();
        }
        Zone zone = TracyClient.beginZone((String)location, (String)string, (String)string2, (int)i);
        this.activeZones.add(zone);
    }

    @Override
    @Override
    public void push(Supplier<String> locationGetter) {
        this.push(locationGetter.get());
    }

    @Override
    @Override
    public void pop() {
        if (this.activeZones.isEmpty()) {
            LOGGER.error("Tried to pop one too many times! Mismatched push() and pop()?");
            return;
        }
        Zone zone = this.activeZones.removeLast();
        zone.close();
    }

    @Override
    @Override
    public void popPush(String location) {
        this.pop();
        this.push(location);
    }

    @Override
    @Override
    public void popPush(Supplier<String> locationGetter) {
        this.pop();
        this.push(locationGetter.get());
    }

    @Override
    @Override
    public void markForCharting(MetricCategory type) {
    }

    @Override
    @Override
    public void incrementCounter(String marker, int num) {
        this.plots.computeIfAbsent(marker, markerName -> new PlotAndValue(this.name + " " + marker)).add(num);
    }

    @Override
    @Override
    public void incrementCounter(Supplier<String> markerGetter, int num) {
        this.incrementCounter(markerGetter.get(), num);
    }

    private Zone activeZone() {
        return this.activeZones.getLast();
    }

    @Override
    @Override
    public void addZoneText(String label) {
        this.activeZone().addText(label);
    }

    @Override
    @Override
    public void addZoneValue(long value) {
        this.activeZone().addValue(value);
    }

    @Override
    @Override
    public void setZoneColor(int color) {
        this.activeZone().setColor(color);
    }

    static final class PlotAndValue {
        private final Plot plot;
        private int value;

        PlotAndValue(String name) {
            this.plot = TracyClient.createPlot((String)name);
            this.value = 0;
        }

        void set(int count) {
            this.value = count;
            this.plot.setValue((double)count);
        }

        void add(int count) {
            this.set(this.value + count);
        }
    }
}

