/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.profiling.ProfilerFiller;

public class Zone
implements AutoCloseable {
    public static final Zone INACTIVE = new Zone(null);
    @Nullable
    private final ProfilerFiller profiler;

    Zone(@Nullable ProfilerFiller wrapped) {
        this.profiler = wrapped;
    }

    public Zone addText(String label) {
        if (this.profiler != null) {
            this.profiler.addZoneText(label);
        }
        return this;
    }

    public Zone addText(Supplier<String> labelSupplier) {
        if (this.profiler != null) {
            this.profiler.addZoneText(labelSupplier.get());
        }
        return this;
    }

    public Zone addValue(long value) {
        if (this.profiler != null) {
            this.profiler.addZoneValue(value);
        }
        return this;
    }

    public Zone setColor(int color) {
        if (this.profiler != null) {
            this.profiler.setZoneColor(color);
        }
        return this;
    }

    @Override
    @Override
    public void close() {
        if (this.profiler != null) {
            this.profiler.pop();
        }
    }
}

