/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.util.thread.TaskScheduler;
import org.slf4j.Logger;

public abstract class AbstractConsecutiveExecutor<T extends Runnable>
implements ProfilerMeasured,
TaskScheduler<T>,
Runnable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.SLEEPING);
    private final StrictQueue<T> queue;
    private final Executor executor;
    private final String name;

    public AbstractConsecutiveExecutor(StrictQueue<T> queue, Executor executor, String name) {
        this.executor = executor;
        this.queue = queue;
        this.name = name;
        MetricsRegistry.INSTANCE.add(this);
    }

    private boolean canBeScheduled() {
        return !this.isClosed() && !this.queue.isEmpty();
    }

    @Override
    @Override
    public void close() {
        this.status.set(Status.CLOSED);
    }

    private boolean pollTask() {
        if (!this.isRunning()) {
            return false;
        }
        Runnable runnable = this.queue.pop();
        if (runnable == null) {
            return false;
        }
        Util.runNamed(runnable, this.name);
        return true;
    }

    @Override
    @Override
    public void run() {
        try {
            this.pollTask();
        }
        finally {
            this.setSleeping();
            this.registerForExecution();
        }
    }

    public void runAll() {
        try {
            while (this.pollTask()) {
            }
        }
        finally {
            this.setSleeping();
            this.registerForExecution();
        }
    }

    @Override
    @Override
    public void schedule(T runnable) {
        this.queue.push(runnable);
        this.registerForExecution();
    }

    private void registerForExecution() {
        if (this.canBeScheduled() && this.setRunning()) {
            try {
                this.executor.execute(this);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException rejectedExecutionException2) {
                    LOGGER.error("Could not schedule ConsecutiveExecutor", (Throwable)rejectedExecutionException2);
                }
            }
        }
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasWork() {
        return this.isRunning() && !this.queue.isEmpty();
    }

    @Override
    public String toString() {
        return this.name + " " + String.valueOf((Object)this.status.get()) + " " + this.queue.isEmpty();
    }

    @Override
    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Override
    public List<MetricSampler> profiledMetrics() {
        return ImmutableList.of((Object)MetricSampler.create(this.name + "-queue-size", MetricCategory.CONSECUTIVE_EXECUTORS, this::size));
    }

    private boolean setRunning() {
        return this.status.compareAndSet(Status.SLEEPING, Status.RUNNING);
    }

    private void setSleeping() {
        this.status.compareAndSet(Status.RUNNING, Status.SLEEPING);
    }

    private boolean isRunning() {
        return this.status.get() == Status.RUNNING;
    }

    private boolean isClosed() {
        return this.status.get() == Status.CLOSED;
    }

    static enum Status {
        SLEEPING,
        RUNNING,
        CLOSED;

    }
}

