/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public record LockCode(ItemPredicate predicate) {
    public static final LockCode NO_LOCK = new LockCode(ItemPredicate.Builder.item().build());
    public static final Codec<LockCode> CODEC = ItemPredicate.CODEC.xmap(LockCode::new, LockCode::predicate);
    public static final String TAG_LOCK = "lock";

    public boolean unlocksWith(ItemStack stack) {
        return this.predicate.test(stack);
    }

    public void addToTag(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this != NO_LOCK) {
            DataResult dataResult = CODEC.encode((Object)this, registries.createSerializationContext(NbtOps.INSTANCE), (Object)new CompoundTag());
            dataResult.result().ifPresent(lock -> nbt.put(TAG_LOCK, (Tag)lock));
        }
    }

    public static LockCode fromTag(CompoundTag nbt, HolderLookup.Provider registries) {
        DataResult dataResult;
        if (nbt.contains(TAG_LOCK, 10) && (dataResult = CODEC.decode(registries.createSerializationContext(NbtOps.INSTANCE), (Object)nbt.get(TAG_LOCK))).isSuccess()) {
            return (LockCode)((Pair)dataResult.getOrThrow()).getFirst();
        }
        return NO_LOCK;
    }
}

