/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class RandomSequences
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long worldSeed;
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<ResourceLocation, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public static SavedData.Factory<RandomSequences> factory(long seed) {
        return new SavedData.Factory<RandomSequences>(() -> new RandomSequences(seed), (nbt, registries) -> RandomSequences.load(seed, nbt), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    }

    public RandomSequences(long seed) {
        this.worldSeed = seed;
    }

    public RandomSource get(ResourceLocation id) {
        RandomSource randomSource = this.sequences.computeIfAbsent(id, this::createSequence).random();
        return new DirtyMarkingRandomSource(randomSource);
    }

    private RandomSequence createSequence(ResourceLocation id) {
        return this.createSequence(id, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(ResourceLocation id, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        long l = (includeWorldSeed ? this.worldSeed : 0L) ^ (long)salt;
        return new RandomSequence(l, includeSequenceId ? Optional.of(id) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<ResourceLocation, RandomSequence> consumer) {
        this.sequences.forEach(consumer);
    }

    public void setSeedDefaults(int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.salt = salt;
        this.includeWorldSeed = includeWorldSeed;
        this.includeSequenceId = includeSequenceId;
    }

    @Override
    @Override
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putInt("salt", this.salt);
        nbt.putBoolean("include_world_seed", this.includeWorldSeed);
        nbt.putBoolean("include_sequence_id", this.includeSequenceId);
        CompoundTag compoundTag = new CompoundTag();
        this.sequences.forEach((id, sequence) -> compoundTag.put(id.toString(), (Tag)RandomSequence.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, sequence).result().orElseThrow()));
        nbt.put("sequences", compoundTag);
        return nbt;
    }

    private static boolean getBooleanWithDefault(CompoundTag nbt, String key, boolean fallback) {
        if (nbt.contains(key, 1)) {
            return nbt.getBoolean(key);
        }
        return fallback;
    }

    public static RandomSequences load(long seed, CompoundTag nbt) {
        RandomSequences randomSequences = new RandomSequences(seed);
        randomSequences.setSeedDefaults(nbt.getInt("salt"), RandomSequences.getBooleanWithDefault(nbt, "include_world_seed", true), RandomSequences.getBooleanWithDefault(nbt, "include_sequence_id", true));
        CompoundTag compoundTag = nbt.getCompound("sequences");
        Set<String> set = compoundTag.getAllKeys();
        for (String string : set) {
            try {
                RandomSequence randomSequence = (RandomSequence)((Pair)RandomSequence.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(string)).result().get()).getFirst();
                randomSequences.sequences.put(ResourceLocation.parse(string), randomSequence);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load random sequence {}", (Object)string, (Object)exception);
            }
        }
        return randomSequences;
    }

    public int clear() {
        int i = this.sequences.size();
        this.sequences.clear();
        return i;
    }

    public void reset(ResourceLocation id) {
        this.sequences.put(id, this.createSequence(id));
    }

    public void reset(ResourceLocation id, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.sequences.put(id, this.createSequence(id, salt, includeWorldSeed, includeSequenceId));
    }

    class DirtyMarkingRandomSource
    implements RandomSource {
        private final RandomSource random;

        DirtyMarkingRandomSource(RandomSource random) {
            this.random = random;
        }

        @Override
        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        @Override
        public void setSeed(long seed) {
            RandomSequences.this.setDirty();
            this.random.setSeed(seed);
        }

        @Override
        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        @Override
        public int nextInt(int bound) {
            RandomSequences.this.setDirty();
            return this.random.nextInt(bound);
        }

        @Override
        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DirtyMarkingRandomSource) {
                DirtyMarkingRandomSource dirtyMarkingRandomSource = (DirtyMarkingRandomSource)object;
                return this.random.equals(dirtyMarkingRandomSource.random);
            }
            return false;
        }
    }
}

