/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;

class HealOrHarmMobEffect
extends InstantenousMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectCategory category, int color, boolean damage) {
        super(category, color);
        this.isHarm = damage;
    }

    @Override
    public boolean applyEffectTick(ServerLevel world, LivingEntity entity, int amplifier) {
        if (this.isHarm == entity.isInvertedHealAndHarm()) {
            entity.heal(Math.max(4 << amplifier, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            entity.hurtServer(world, entity.damageSources().magic(), 6 << amplifier);
        }
        return true;
    }

    @Override
    public void applyInstantenousEffect(ServerLevel world, @Nullable Entity effectEntity, @Nullable Entity attacker, LivingEntity target, int amplifier, double proximity) {
        if (this.isHarm == target.isInvertedHealAndHarm()) {
            int j = (int)(proximity * (double)(4 << amplifier) + 0.5);
            target.heal(j, EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            int j = (int)(proximity * (double)(6 << amplifier) + 0.5);
            if (effectEntity == null) {
                target.hurtServer(world, target.damageSources().magic(), j);
            } else {
                target.hurtServer(world, target.damageSources().indirectMagic(effectEntity, attacker), j);
            }
        }
    }
}

