/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;

public class Marker
extends Entity {
    private static final String DATA_TAG = "data";
    private CompoundTag data = new CompoundTag();

    public Marker(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
    }

    @Override
    @Override
    public void tick() {
    }

    @Override
    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.data = nbt.getCompound(DATA_TAG);
    }

    @Override
    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put(DATA_TAG, this.data.copy());
    }

    @Override
    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        throw new IllegalStateException("Markers should never be sent");
    }

    @Override
    @Override
    protected boolean canAddPassenger(Entity passenger) {
        return false;
    }

    @Override
    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    @Override
    protected void addPassenger(Entity passenger) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    @Override
    public final boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        return false;
    }
}

