/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.Mth;

public class WalkAnimationState {
    private float speedOld;
    private float speed;
    private float position;
    private float positionScale = 1.0f;

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void update(float speed, float multiplier, float scale) {
        this.speedOld = this.speed;
        this.speed += (speed - this.speed) * multiplier;
        this.position += this.speed;
        this.positionScale = scale;
    }

    public void stop() {
        this.speedOld = 0.0f;
        this.speed = 0.0f;
        this.position = 0.0f;
    }

    public float speed() {
        return this.speed;
    }

    public float speed(float tickDelta) {
        return Math.min(Mth.lerp(tickDelta, this.speedOld, this.speed), 1.0f);
    }

    public float position() {
        return this.position * this.positionScale;
    }

    public float position(float tickDelta) {
        return (this.position - this.speed * (1.0f - tickDelta)) * this.positionScale;
    }

    public boolean isMoving() {
        return this.speed > 1.0E-5f;
    }
}

