/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;

public class AnimalMakeLove
extends Behavior<Animal> {
    private static final int BREED_RANGE = 3;
    private static final int MIN_DURATION = 60;
    private static final int MAX_DURATION = 110;
    private final EntityType<? extends Animal> partnerType;
    private final float speedModifier;
    private final int closeEnoughDistance;
    private static final int DEFAULT_CLOSE_ENOUGH_DISTANCE = 2;
    private long spawnChildAtTime;

    public AnimalMakeLove(EntityType<? extends Animal> targetType) {
        this(targetType, 1.0f, 2);
    }

    public AnimalMakeLove(EntityType<? extends Animal> targetType, float speed, int approachDistance) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 110);
        this.partnerType = targetType;
        this.speedModifier = speed;
        this.closeEnoughDistance = approachDistance;
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Animal entity) {
        return entity.isInLove() && this.findValidBreedPartner(entity).isPresent();
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, Animal animal, long l) {
        Animal animal2 = this.findValidBreedPartner(animal).get();
        animal.getBrain().setMemory(MemoryModuleType.BREED_TARGET, animal2);
        animal2.getBrain().setMemory(MemoryModuleType.BREED_TARGET, animal);
        BehaviorUtils.lockGazeAndWalkToEachOther(animal, animal2, this.speedModifier, this.closeEnoughDistance);
        int i = 60 + animal.getRandom().nextInt(50);
        this.spawnChildAtTime = l + (long)i;
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel serverLevel, Animal animal, long l) {
        if (!this.hasBreedTargetOfRightType(animal)) {
            return false;
        }
        Animal animal2 = this.getBreedTarget(animal);
        return animal2.isAlive() && animal.canMate(animal2) && BehaviorUtils.entityIsVisible(animal.getBrain(), animal2) && l <= this.spawnChildAtTime && !animal.isPanicking() && !animal2.isPanicking();
    }

    @Override
    @Override
    protected void tick(ServerLevel world, Animal entity, long time) {
        Animal animal = this.getBreedTarget(entity);
        BehaviorUtils.lockGazeAndWalkToEachOther(entity, animal, this.speedModifier, this.closeEnoughDistance);
        if (!entity.closerThan(animal, 3.0)) {
            return;
        }
        if (time >= this.spawnChildAtTime) {
            entity.spawnChildFromBreeding(world, animal);
            entity.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
            animal.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        }
    }

    @Override
    @Override
    protected void stop(ServerLevel serverLevel, Animal animal, long l) {
        animal.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
        animal.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        animal.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        this.spawnChildAtTime = 0L;
    }

    private Animal getBreedTarget(Animal animal) {
        return (Animal)animal.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
    }

    private boolean hasBreedTargetOfRightType(Animal animal) {
        Brain<AgeableMob> brain = animal.getBrain();
        return brain.hasMemoryValue(MemoryModuleType.BREED_TARGET) && brain.getMemory(MemoryModuleType.BREED_TARGET).get().getType() == this.partnerType;
    }

    private Optional<? extends Animal> findValidBreedPartner(Animal animal) {
        return animal.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().findClosest(entity -> {
            Animal animal2;
            return entity.getType() == this.partnerType && entity instanceof Animal && animal.canMate(animal2 = (Animal)entity) && !animal2.isPanicking();
        }).map(Animal.class::cast);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel world, LivingEntity entity, long time) {
        return this.canStillUse(world, (Animal)entity, time);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel world, LivingEntity entity, long time) {
        this.stop(world, (Animal)entity, time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (Animal)entity, time);
    }
}

