/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;

public class MeleeAttack {
    public static <T extends Mob> OneShot<T> create(int cooldown) {
        return MeleeAttack.create(target -> true, cooldown);
    }

    public static <T extends Mob> OneShot<T> create(Predicate<T> targetPredicate, int cooldown) {
        return BehaviorBuilder.create(context -> context.group(context.registered(MemoryModuleType.LOOK_TARGET), context.present(MemoryModuleType.ATTACK_TARGET), context.absent(MemoryModuleType.ATTACK_COOLING_DOWN), context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (lookTarget, attackTarget, attackCoolingDown, visibleMobs) -> (world, entity, time) -> {
            LivingEntity livingEntity = (LivingEntity)context.get(attackTarget);
            if (targetPredicate.test(entity) && !MeleeAttack.isHoldingUsableProjectileWeapon(entity) && entity.isWithinMeleeAttackRange(livingEntity) && ((NearestVisibleLivingEntities)context.get(visibleMobs)).contains(livingEntity)) {
                lookTarget.set(new EntityTracker(livingEntity, true));
                entity.swing(InteractionHand.MAIN_HAND);
                entity.doHurtTarget(world, livingEntity);
                attackCoolingDown.setWithExpiry(true, cooldown);
                return true;
            }
            return false;
        }));
    }

    private static boolean isHoldingUsableProjectileWeapon(Mob mob) {
        return mob.isHolding(stack -> {
            Item item = stack.getItem();
            return item instanceof ProjectileWeaponItem && mob.canFireProjectileWeapon((ProjectileWeaponItem)item);
        });
    }
}

