/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StopAttackingIfTargetInvalid {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends Mob> BehaviorControl<E> create(TargetErasedCallback<E> callback) {
        return StopAttackingIfTargetInvalid.create((worldserver, entityliving) -> false, callback, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition condition) {
        return StopAttackingIfTargetInvalid.create(condition, (worldserver, entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create() {
        return StopAttackingIfTargetInvalid.create((worldserver, entityliving) -> false, (worldserver, entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(StopAttackCondition condition, TargetErasedCallback<E> callback, boolean shouldForgetIfTargetUnreachable) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i) -> {
            LivingEntity entityliving = (LivingEntity)behaviorbuilder_b.get(memoryaccessor);
            if (!(!entityinsentient.canAttack(entityliving) || shouldForgetIfTargetUnreachable && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) || !entityliving.isAlive() || entityliving.level() != entityinsentient.level() || condition.test(worldserver, entityliving))) {
                return true;
            }
            EntityTargetEvent.TargetReason reason = !entityinsentient.canAttack(entityliving) ? EntityTargetEvent.TargetReason.TARGET_INVALID : (shouldForgetIfTargetUnreachable && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) ? EntityTargetEvent.TargetReason.FORGOT_TARGET : (!entityliving.isAlive() ? EntityTargetEvent.TargetReason.TARGET_DIED : (entityliving.level() != entityinsentient.level() ? EntityTargetEvent.TargetReason.TARGET_OTHER_LEVEL : EntityTargetEvent.TargetReason.TARGET_INVALID)));
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, null, reason);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() != null) {
                entityinsentient.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, ((CraftLivingEntity)event.getTarget()).getHandle());
                return true;
            }
            callback.accept(worldserver, entityinsentient, entityliving);
            memoryaccessor.erase();
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity target, Optional<Long> lastReachTime) {
        return lastReachTime.isPresent() && target.level().getGameTime() - lastReachTime.get() > 200L;
    }

    @FunctionalInterface
    public static interface StopAttackCondition {
        public boolean test(ServerLevel var1, LivingEntity var2);
    }

    @FunctionalInterface
    public static interface TargetErasedCallback<E> {
        public void accept(ServerLevel var1, E var2, LivingEntity var3);
    }
}

