/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class PiglinSpecificSensor
extends Sensor<LivingEntity> {
    @Override
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, (Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.NEARBY_ADULT_PIGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT});
    }

    @Override
    @Override
    protected void doTick(ServerLevel world, LivingEntity entity) {
        Brain<?> brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_REPELLENT, PiglinSpecificSensor.findNearestRepellent(world, entity));
        Optional<Object> optional = Optional.empty();
        Optional<Object> optional2 = Optional.empty();
        Optional<Object> optional3 = Optional.empty();
        Optional<Object> optional4 = Optional.empty();
        Optional<Object> optional5 = Optional.empty();
        Optional<Object> optional6 = Optional.empty();
        Optional<Object> optional7 = Optional.empty();
        int i = 0;
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        NearestVisibleLivingEntities nearestVisibleLivingEntities = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity livingEntity2 : nearestVisibleLivingEntities.findAll(livingEntity -> true)) {
            if (livingEntity2 instanceof Hoglin) {
                Hoglin hoglin = (Hoglin)livingEntity2;
                if (hoglin.isBaby() && optional3.isEmpty()) {
                    optional3 = Optional.of(hoglin);
                    continue;
                }
                if (!hoglin.isAdult()) continue;
                ++i;
                if (!optional2.isEmpty() || !hoglin.canBeHunted()) continue;
                optional2 = Optional.of(hoglin);
                continue;
            }
            if (livingEntity2 instanceof PiglinBrute) {
                PiglinBrute piglinBrute = (PiglinBrute)livingEntity2;
                list.add(piglinBrute);
                continue;
            }
            if (livingEntity2 instanceof Piglin) {
                Piglin piglin = (Piglin)livingEntity2;
                if (piglin.isBaby() && optional4.isEmpty()) {
                    optional4 = Optional.of(piglin);
                    continue;
                }
                if (!piglin.isAdult()) continue;
                list.add(piglin);
                continue;
            }
            if (livingEntity2 instanceof Player) {
                Player player = (Player)livingEntity2;
                if (optional6.isEmpty() && !PiglinAi.isWearingSafeArmor(player) && entity.canAttack(livingEntity2)) {
                    optional6 = Optional.of(player);
                }
                if (!optional7.isEmpty() || player.isSpectator() || !PiglinAi.isPlayerHoldingLovedItem(player)) continue;
                optional7 = Optional.of(player);
                continue;
            }
            if (optional.isEmpty() && (livingEntity2 instanceof WitherSkeleton || livingEntity2 instanceof WitherBoss)) {
                optional = Optional.of((Mob)livingEntity2);
                continue;
            }
            if (!optional5.isEmpty() || !PiglinAi.isZombified(livingEntity2.getType())) continue;
            optional5 = Optional.of(livingEntity2);
        }
        List<LivingEntity> list3 = brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).orElse((List<LivingEntity>)ImmutableList.of());
        for (LivingEntity livingEntity2 : list3) {
            AbstractPiglin abstractPiglin;
            if (!(livingEntity2 instanceof AbstractPiglin) || !(abstractPiglin = (AbstractPiglin)livingEntity2).isAdult()) continue;
            list2.add(abstractPiglin);
        }
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS, optional);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, optional2);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, optional3);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, optional5);
        brain.setMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, optional6);
        brain.setMemory(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, optional7);
        brain.setMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS, list2);
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, list);
        brain.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, list.size());
        brain.setMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, i);
    }

    private static Optional<BlockPos> findNearestRepellent(ServerLevel world, LivingEntity entity) {
        return BlockPos.findClosestMatch(entity.blockPosition(), 8, 4, pos -> PiglinSpecificSensor.isValidRepellent(world, pos));
    }

    private static boolean isValidRepellent(ServerLevel world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        boolean bl = blockState.is(BlockTags.PIGLIN_REPELLENTS);
        if (bl && blockState.is(Blocks.SOUL_CAMPFIRE)) {
            return CampfireBlock.isLitCampfire(blockState);
        }
        return bl;
    }
}

