/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class RandomPos {
    private static final int RANDOM_POS_ATTEMPTS = 10;

    public static BlockPos generateRandomDirection(RandomSource random, int horizontalRange, int verticalRange) {
        int i = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        int j = random.nextInt(2 * verticalRange + 1) - verticalRange;
        int k = random.nextInt(2 * horizontalRange + 1) - horizontalRange;
        return new BlockPos(i, j, k);
    }

    @Nullable
    public static BlockPos generateRandomDirectionWithinRadians(RandomSource random, int horizontalRange, int verticalRange, int startHeight, double directionX, double directionZ, double angleRange) {
        double d = Mth.atan2(directionZ, directionX) - 1.5707963705062866;
        double e = d + (double)(2.0f * random.nextFloat() - 1.0f) * angleRange;
        double f = Math.sqrt(random.nextDouble()) * (double)Mth.SQRT_OF_TWO * (double)horizontalRange;
        double g = -f * Math.sin(e);
        double h = f * Math.cos(e);
        if (Math.abs(g) > (double)horizontalRange || Math.abs(h) > (double)horizontalRange) {
            return null;
        }
        int i = random.nextInt(2 * verticalRange + 1) - verticalRange + startHeight;
        return BlockPos.containing(g, i, h);
    }

    @VisibleForTesting
    public static BlockPos moveUpOutOfSolid(BlockPos pos, int maxY, Predicate<BlockPos> condition) {
        if (condition.test(pos)) {
            BlockPos.MutableBlockPos mutableBlockPos = pos.mutable().move(Direction.UP);
            while (mutableBlockPos.getY() <= maxY && condition.test(mutableBlockPos)) {
                mutableBlockPos.move(Direction.UP);
            }
            return mutableBlockPos.immutable();
        }
        return pos;
    }

    @VisibleForTesting
    public static BlockPos moveUpToAboveSolid(BlockPos pos, int extraAbove, int max, Predicate<BlockPos> condition) {
        if (extraAbove < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + extraAbove + ", expected >= 0");
        }
        if (condition.test(pos)) {
            BlockPos.MutableBlockPos mutableBlockPos = pos.mutable().move(Direction.UP);
            while (mutableBlockPos.getY() <= max && condition.test(mutableBlockPos)) {
                mutableBlockPos.move(Direction.UP);
            }
            int i = mutableBlockPos.getY();
            while (mutableBlockPos.getY() <= max && mutableBlockPos.getY() - i < extraAbove) {
                mutableBlockPos.move(Direction.UP);
                if (!condition.test(mutableBlockPos)) continue;
                mutableBlockPos.move(Direction.DOWN);
                break;
            }
            return mutableBlockPos.immutable();
        }
        return pos;
    }

    @Nullable
    public static Vec3 generateRandomPos(PathfinderMob entity, Supplier<BlockPos> factory) {
        return RandomPos.generateRandomPos(factory, entity::getWalkTargetValue);
    }

    @Nullable
    public static Vec3 generateRandomPos(Supplier<BlockPos> factory, ToDoubleFunction<BlockPos> scorer) {
        double d = Double.NEGATIVE_INFINITY;
        BlockPos blockPos = null;
        for (int i = 0; i < 10; ++i) {
            double e;
            BlockPos blockPos2 = factory.get();
            if (blockPos2 == null || !((e = scorer.applyAsDouble(blockPos2)) > d)) continue;
            d = e;
            blockPos = blockPos2;
        }
        return blockPos != null ? Vec3.atBottomCenterOf(blockPos) : null;
    }

    public static BlockPos generateRandomPosTowardDirection(PathfinderMob entity, int horizontalRange, RandomSource random, BlockPos fuzz) {
        int i = fuzz.getX();
        int j = fuzz.getZ();
        if (entity.hasRestriction() && horizontalRange > 1) {
            BlockPos blockPos = entity.getRestrictCenter();
            i = entity.getX() > (double)blockPos.getX() ? (i -= random.nextInt(horizontalRange / 2)) : (i += random.nextInt(horizontalRange / 2));
            j = entity.getZ() > (double)blockPos.getZ() ? (j -= random.nextInt(horizontalRange / 2)) : (j += random.nextInt(horizontalRange / 2));
        }
        return BlockPos.containing((double)i + entity.getX(), (double)fuzz.getY() + entity.getY(), (double)j + entity.getZ());
    }
}

