/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.purpurmc.purpur.entity.ai.HasRider;

public class SnowGolem
extends AbstractGolem
implements Shearable,
RangedAttackMob {
    private static final EntityDataAccessor<Byte> DATA_PUMPKIN_ID = SynchedEntityData.defineId(SnowGolem.class, EntityDataSerializers.BYTE);
    private static final byte PUMPKIN_FLAG = 16;
    @Nullable
    private UUID summoner;

    public SnowGolem(EntityType<? extends SnowGolem> type, Level world) {
        super((EntityType<? extends AbstractGolem>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.level().purpurConfig.snowGolemRidable;
    }

    @Override
    public boolean dismountsUnderwater() {
        return this.level().purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !this.level().purpurConfig.snowGolemRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.level().purpurConfig.snowGolemControllable;
    }

    @Override
    public void initAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(this.level().purpurConfig.snowGolemMaxHealth);
        this.getAttribute(Attributes.SCALE).setBaseValue(this.level().purpurConfig.snowGolemScale);
    }

    @Nullable
    public UUID getSummoner() {
        return this.summoner;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoner = summoner;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return this.level().purpurConfig.snowGolemAlwaysDropExp;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new HasRider(this));
        this.goalSelector.addGoal(1, new RangedAttackGoal(this, this.level().purpurConfig.snowGolemAttackDistance, this.level().purpurConfig.snowGolemSnowBallMin, this.level().purpurConfig.snowGolemSnowBallMax, this.level().purpurConfig.snowGolemSnowBallModifier));
        this.goalSelector.addGoal(2, new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(3, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(0, new HasRider(this));
        this.targetSelector.addGoal(1, new NearestAttackableTargetGoal<Mob>(this, Mob.class, 10, true, false, (entityliving, worldserver) -> entityliving instanceof Enemy));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.2f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PUMPKIN_ID, (byte)16);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Pumpkin", this.hasPumpkin());
        if (this.getSummoner() != null) {
            nbt.putUUID("Purpur.Summoner", this.getSummoner());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("Pumpkin")) {
            this.setPumpkin(nbt.getBoolean("Pumpkin"));
        }
        if (nbt.contains("Purpur.Summoner")) {
            this.setSummoner(nbt.getUUID("Purpur.Summoner"));
        }
    }

    @Override
    public boolean isSensitiveToWater() {
        return this.level().purpurConfig.snowGolemTakeDamageFromWater;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
                this.hurtServer(worldserver, this.damageSources().melting(), 1.0f);
            }
            if (!worldserver.purpurConfig.snowGolemBypassMobGriefing == !worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            if (this.getRider() != null && this.isControllable() && !this.level().purpurConfig.snowGolemLeaveTrailWhenRidden) {
                return;
            }
            BlockState iblockdata = Blocks.SNOW.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                int j = Mth.floor(this.getX() + (double)((float)(i % 2 * 2 - 1) * 0.25f));
                int k = Mth.floor(this.getY());
                int l = Mth.floor(this.getZ() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f));
                BlockPos blockposition = new BlockPos(j, k, l);
                if (!this.level().getBlockState(blockposition).isAir() || !iblockdata.canSurvive(this.level(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, this)) continue;
                this.level().gameEvent(GameEvent.BLOCK_PLACE, blockposition, GameEvent.Context.of(this, iblockdata));
            }
        }
    }

    @Override
    public void performRangedAttack(LivingEntity target, float pullProgress) {
        double d0 = target.getX() - this.getX();
        double d1 = target.getEyeY() - (double)1.1f;
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ItemStack itemstack = new ItemStack(Items.SNOWBALL);
            Projectile.spawnProjectile(new Snowball(worldserver, this, itemstack), worldserver, itemstack, entitysnowball -> entitysnowball.shoot(d0, d1 + d3 - entitysnowball.getY(), d2, 1.6f, 12.0f));
        }
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(Items.SHEARS) && this.readyForShearing()) {
            Level world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                List<ItemStack> drops = this.generateDefaultDrops(worldserver, itemstack);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return this.tryRide(player, hand);
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(worldserver, SoundSource.PLAYERS, itemstack, drops);
                this.gameEvent(GameEvent.SHEAR, player);
                itemstack.hurtAndBreak(1, player, SnowGolem.getSlotForHand(hand));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.level().purpurConfig.snowGolemPutPumpkinBack && !this.hasPumpkin() && itemstack.getItem() == Blocks.CARVED_PUMPKIN.asItem()) {
            this.setPumpkin(true);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return this.tryRide(player, hand);
    }

    @Override
    public void shear(ServerLevel world, SoundSource shearedSoundCategory, ItemStack shears) {
        this.shear(world, shearedSoundCategory, shears, this.generateDefaultDrops(world, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(ServerLevel serverLevel, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.dropFromShearingLootTable(serverLevel, BuiltInLootTables.SHEAR_SNOW_GOLEM, shears, (arg_0, arg_1) -> SnowGolem.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(ServerLevel world, SoundSource shearedSoundCategory, ItemStack shears, List<ItemStack> drops) {
        ServerLevel worldserver1 = world;
        world.playSound((Player)null, this, SoundEvents.SNOW_GOLEM_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setPumpkin(false);
        drops.forEach(itemstack1 -> {
            this.forceDrops = true;
            this.spawnAtLocation(worldserver1, (ItemStack)itemstack1, this.getEyeHeight());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.hasPumpkin();
    }

    public boolean hasPumpkin() {
        return (this.entityData.get(DATA_PUMPKIN_ID) & 0x10) != 0;
    }

    public void setPumpkin(boolean hasPumpkin) {
        byte b0 = this.entityData.get(DATA_PUMPKIN_ID);
        if (hasPumpkin) {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 | 0x10));
        } else {
            this.entityData.set(DATA_PUMPKIN_ID, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.SNOW_GOLEM_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SNOW_GOLEM_HURT;
    }

    @Override
    @Nullable
    public SoundEvent getDeathSound() {
        return SoundEvents.SNOW_GOLEM_DEATH;
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.75f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, ServerLevel ignored, ItemStack stack) {
        drops.add(stack);
    }
}

