/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public class ShootTongue
extends Behavior<Frog> {
    public static final int TIME_OUT_DURATION = 100;
    public static final int CATCH_ANIMATION_DURATION = 6;
    public static final int TONGUE_ANIMATION_DURATION = 10;
    private static final float EATING_DISTANCE = 1.75f;
    private static final float EATING_MOVEMENT_FACTOR = 0.75f;
    public static final int UNREACHABLE_TONGUE_TARGETS_COOLDOWN_DURATION = 100;
    public static final int MAX_UNREACHBLE_TONGUE_TARGETS_IN_MEMORY = 5;
    private int eatAnimationTimer;
    private int calculatePathCounter;
    private final SoundEvent tongueSound;
    private final SoundEvent eatSound;
    private Vec3 itemSpawnPos;
    private State state = State.DONE;

    public ShootTongue(SoundEvent tongueSound, SoundEvent eatSound) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 100);
        this.tongueSound = tongueSound;
        this.eatSound = eatSound;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Frog entity) {
        LivingEntity entityliving = entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        boolean flag = this.canPathfindToTarget(entity, entityliving);
        if (!flag) {
            entity.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            this.addUnreachableTargetToMemory(entity, entityliving);
        }
        return flag && entity.getPose() != Pose.CROAKING && Frog.canEat(entityliving);
    }

    @Override
    protected boolean canStillUse(ServerLevel world, Frog entity, long time) {
        return entity.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.state != State.DONE && !entity.getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void start(ServerLevel worldserver, Frog frog, long i) {
        LivingEntity entityliving = frog.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        BehaviorUtils.lookAtEntity(frog, entityliving);
        frog.setTongueTarget(entityliving);
        frog.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(entityliving.position(), 2.0f, 0));
        this.calculatePathCounter = 10;
        this.state = State.MOVE_TO_TARGET;
    }

    @Override
    protected void stop(ServerLevel worldserver, Frog frog, long i) {
        frog.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        frog.eraseTongueTarget();
        frog.setPose(Pose.STANDING);
    }

    private void eatEntity(ServerLevel world, Frog frog) {
        Entity entity;
        world.playSound((Player)null, frog, this.eatSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
        Optional<Entity> optional = frog.getTongueTarget();
        if (optional.isPresent() && (entity = optional.get()).isAlive()) {
            frog.doHurtTarget(world, entity);
            if (!entity.isAlive()) {
                entity.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
            }
        }
    }

    @Override
    protected void tick(ServerLevel worldserver, Frog frog, long i) {
        LivingEntity entityliving = frog.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        frog.setTongueTarget(entityliving);
        switch (this.state.ordinal()) {
            case 0: {
                if (entityliving.distanceTo(frog) < 1.75f) {
                    worldserver.playSound((Player)null, frog, this.tongueSound, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    frog.setPose(Pose.USING_TONGUE);
                    entityliving.setDeltaMovement(entityliving.position().vectorTo(frog.position()).normalize().scale(0.75));
                    this.itemSpawnPos = entityliving.position();
                    this.eatAnimationTimer = 0;
                    this.state = State.CATCH_ANIMATION;
                    break;
                }
                if (this.calculatePathCounter <= 0) {
                    frog.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(entityliving.position(), 2.0f, 0));
                    this.calculatePathCounter = 10;
                    break;
                }
                --this.calculatePathCounter;
                break;
            }
            case 1: {
                if (this.eatAnimationTimer++ < 6) break;
                this.state = State.EAT_ANIMATION;
                this.eatEntity(worldserver, frog);
                break;
            }
            case 2: {
                if (this.eatAnimationTimer >= 10) {
                    this.state = State.DONE;
                    break;
                }
                ++this.eatAnimationTimer;
            }
        }
    }

    private boolean canPathfindToTarget(Frog entity, LivingEntity target) {
        Path pathentity = entity.getNavigation().createPath(target, 0);
        return pathentity != null && pathentity.getDistToTarget() < 1.75f;
    }

    private void addUnreachableTargetToMemory(Frog entity, LivingEntity target) {
        boolean flag;
        List list = entity.getBrain().getMemory(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS).orElseGet(ArrayList::new);
        boolean bl = flag = !list.contains(target.getUUID());
        if (list.size() == 5 && flag) {
            list.remove(0);
        }
        if (flag) {
            list.add(target.getUUID());
        }
        entity.getBrain().setMemoryWithExpiry(MemoryModuleType.UNREACHABLE_TONGUE_TARGETS, list, 100L);
    }

    private static enum State {
        MOVE_TO_TARGET,
        CATCH_ANIMATION,
        EAT_ANIMATION,
        DONE;

    }
}

