/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.level.Level;

public class Donkey
extends AbstractChestedHorse {
    public Donkey(EntityType<? extends Donkey> type, Level world) {
        super((EntityType<? extends AbstractChestedHorse>)type, world);
    }

    @Override
    public boolean dismountsUnderwater() {
        return ((Level)this.level()).purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !((Level)this.level()).purpurConfig.donkeyRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(((Level)this.level()).purpurConfig.donkeyMaxHealthMin, ((Level)this.level()).purpurConfig.donkeyMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(((Level)this.level()).purpurConfig.donkeyJumpStrengthMin, ((Level)this.level()).purpurConfig.donkeyJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(((Level)this.level()).purpurConfig.donkeyMovementSpeedMin, ((Level)this.level()).purpurConfig.donkeyMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return ((Level)this.level()).purpurConfig.donkeyBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return ((Level)this.level()).purpurConfig.donkeyTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return ((Level)this.level()).purpurConfig.donkeyAlwaysDropExp;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.DONKEY_AMBIENT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.DONKEY_ANGRY;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.DONKEY_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.DONKEY_EAT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.DONKEY_HURT;
    }

    @Override
    public boolean canMate(Animal other) {
        return other != this && (other instanceof Donkey || other instanceof Horse) && this.canParent() && ((AbstractHorse)other).canParent();
    }

    @Override
    protected void playJumpSound() {
        this.playSound(SoundEvents.DONKEY_JUMP, 0.4f, 1.0f);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        EntityType<AbstractChestedHorse> entityType = entity instanceof Horse ? EntityType.MULE : EntityType.DONKEY;
        AbstractHorse abstractHorse = entityType.create(world, EntitySpawnReason.BREEDING);
        if (abstractHorse != null) {
            this.setOffspringAttributes(entity, abstractHorse);
        }
        return abstractHorse;
    }
}

