/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.level.Level;

public class Mule
extends AbstractChestedHorse {
    public Mule(EntityType<? extends Mule> type, Level world) {
        super((EntityType<? extends AbstractChestedHorse>)type, world);
    }

    @Override
    public boolean dismountsUnderwater() {
        return ((Level)this.level()).purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !((Level)this.level()).purpurConfig.muleRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(((Level)this.level()).purpurConfig.muleMaxHealthMin, ((Level)this.level()).purpurConfig.muleMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(((Level)this.level()).purpurConfig.muleJumpStrengthMin, ((Level)this.level()).purpurConfig.muleJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(((Level)this.level()).purpurConfig.muleMovementSpeedMin, ((Level)this.level()).purpurConfig.muleMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return ((Level)this.level()).purpurConfig.muleBreedingTicks;
    }

    @Override
    public boolean isSensitiveToWater() {
        return ((Level)this.level()).purpurConfig.muleTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return ((Level)this.level()).purpurConfig.muleAlwaysDropExp;
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.MULE_AMBIENT;
    }

    @Override
    protected SoundEvent getAngrySound() {
        return SoundEvents.MULE_ANGRY;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.MULE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.MULE_EAT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.MULE_HURT;
    }

    @Override
    protected void playJumpSound() {
        this.playSound(SoundEvents.MULE_JUMP, 0.4f, 1.0f);
    }

    @Override
    protected void playChestEquipsSound() {
        this.playSound(SoundEvents.MULE_CHEST, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return EntityType.MULE.create(world, EntitySpawnReason.BREEDING);
    }
}

