/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ZombieHorse
extends AbstractHorse {
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.ZOMBIE_HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityType.ZOMBIE_HORSE.getHeight() - 0.03125f, 0.0f)).scale(0.5f);

    public ZombieHorse(EntityType<? extends ZombieHorse> type, Level world) {
        super((EntityType<? extends AbstractHorse>)type, world);
    }

    @Override
    public boolean dismountsUnderwater() {
        return ((Level)this.level()).purpurConfig.useDismountsUnderwaterTag ? super.dismountsUnderwater() : !((Level)this.level()).purpurConfig.zombieHorseRidableInWater;
    }

    @Override
    public boolean isTamed() {
        return super.isTamed() || ((Level)this.level()).purpurConfig.zombieHorseRidable;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(((Level)this.level()).purpurConfig.zombieHorseMaxHealthMin, ((Level)this.level()).purpurConfig.zombieHorseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(((Level)this.level()).purpurConfig.zombieHorseJumpStrengthMin, ((Level)this.level()).purpurConfig.zombieHorseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(((Level)this.level()).purpurConfig.zombieHorseMovementSpeedMin, ((Level)this.level()).purpurConfig.zombieHorseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean isSensitiveToWater() {
        return ((Level)this.level()).purpurConfig.zombieHorseTakeDamageFromWater;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return ((Level)this.level()).purpurConfig.zombieHorseAlwaysDropExp;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ZombieHorse.createBaseHorseAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.2f);
    }

    public static boolean checkZombieHorseSpawnRules(EntityType<? extends Animal> type, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return !EntitySpawnReason.isSpawner(reason) ? Animal.checkAnimalSpawnRules(type, world, reason, pos, random) : EntitySpawnReason.ignoresLightRequirements(reason) || ZombieHorse.isBrightEnoughToSpawn(world, pos);
    }

    @Override
    protected void randomizeAttributes(RandomSource random) {
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(ZombieHorse.generateJumpStrength(random::nextDouble));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return EntityType.ZOMBIE_HORSE.create(world, EntitySpawnReason.BREEDING);
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return !this.isTamed() ? InteractionResult.PASS : super.mobInteract(player, hand);
    }

    @Override
    protected void addBehaviourGoals() {
        if (((Level)this.level()).purpurConfig.zombieHorseCanSwim) {
            this.goalSelector.addGoal(0, new FloatGoal(this));
        }
    }

    @Override
    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }
}

