/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Arrays;
import net.minecraft.util.Mth;

public class DragonFlightHistory {
    public static final int LENGTH = 64;
    private static final int MASK = 63;
    private final Sample[] samples = new Sample[64];
    private int head = -1;

    public DragonFlightHistory() {
        Arrays.fill(this.samples, new Sample(0.0, 0.0f));
    }

    public void copyFrom(DragonFlightHistory other) {
        System.arraycopy(other.samples, 0, this.samples, 0, 64);
        this.head = other.head;
    }

    public void record(double y, float yaw) {
        Sample sample = new Sample(y, yaw);
        if (this.head < 0) {
            Arrays.fill(this.samples, sample);
        }
        if (++this.head == 64) {
            this.head = 0;
        }
        this.samples[this.head] = sample;
    }

    public Sample get(int age) {
        return this.samples[this.head - age & 0x3F];
    }

    public Sample get(int age, float tickDelta) {
        Sample sample = this.get(age);
        Sample sample2 = this.get(age + 1);
        return new Sample(Mth.lerp((double)tickDelta, sample2.y, sample.y), Mth.rotLerp(tickDelta, sample2.yRot, sample.yRot));
    }

    public record Sample(double y, float yRot) {
    }
}

