/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;

public class ItemEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemEntity.class, EntityDataSerializers.ITEM_STACK);
    private static final float FLOAT_HEIGHT = 0.1f;
    public static final float EYE_HEIGHT = 0.2125f;
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    public int age;
    public int pickupDelay;
    public int health = 5;
    @Nullable
    public UUID thrower;
    @Nullable
    private Entity cachedThrower;
    @Nullable
    public UUID target;
    public final float bobOffs;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;
    public boolean immuneToCactus = false;
    public boolean immuneToExplosion = false;
    public boolean immuneToFire = false;
    public boolean immuneToLightning = false;

    public ItemEntity(EntityType<? extends ItemEntity> type, Level world) {
        super(type, world);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public ItemEntity(Level world, double x, double y, double z, ItemStack stack) {
        this((EntityType<? extends ItemEntity>)EntityType.ITEM, world);
        this.setPos(x, y, z);
        this.setDeltaMovement(this.random.nextDouble() * 0.2 - 0.1, 0.2, this.random.nextDouble() * 0.2 - 0.1);
        this.setItem(stack);
    }

    public ItemEntity(Level world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityType<? extends ItemEntity>)EntityType.ITEM, world);
        this.setPos(x, y, z);
        this.setDeltaMovement(velocityX, velocityY, velocityZ);
        this.setItem(stack);
    }

    private ItemEntity(ItemEntity entity) {
        super(entity.getType(), entity.level());
        this.setItem(entity.getItem().copy());
        this.copyPosition(entity);
        this.age = entity.age;
        this.bobOffs = entity.bobOffs;
    }

    @Override
    public boolean dampensVibrations() {
        return this.getItem().is(ItemTags.DAMPENS_VIBRATIONS);
    }

    @Override
    @Nullable
    public Entity getOwner() {
        Level world;
        if (this.cachedThrower != null && !this.cachedThrower.isRemoved()) {
            return this.cachedThrower;
        }
        if (this.thrower != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.cachedThrower = worldserver.getEntity(this.thrower);
            return this.cachedThrower;
        }
        return null;
    }

    @Override
    public void restoreFrom(Entity original) {
        super.restoreFrom(original);
        if (original instanceof ItemEntity) {
            ItemEntity entityitem = (ItemEntity)original;
            this.cachedThrower = entityitem.cachedThrower;
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.getItem().isEmpty()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i;
            super.tick();
            if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
                --this.pickupDelay;
            }
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            Vec3 vec3d = this.getDeltaMovement();
            if (this.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)0.1f) {
                this.setUnderwaterMovement();
            } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > (double)0.1f) {
                this.setUnderLavaMovement();
            } else {
                this.applyGravity();
            }
            if (this.level().isClientSide) {
                this.noPhysics = false;
            } else {
                boolean bl = this.noPhysics = !this.level().noCollision(this, this.getBoundingBox().deflate(1.0E-7));
                if (this.noPhysics) {
                    this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                }
            }
            if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.applyEffectsFromBlocks();
                float f = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f = 1.0f;
                } else if (this.onGround()) {
                    f = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
                }
                this.setDeltaMovement(this.getDeltaMovement().multiply(f, 0.98, f));
                if (this.onGround()) {
                    Vec3 vec3d1 = this.getDeltaMovement();
                    if (vec3d1.y < 0.0) {
                        this.setDeltaMovement(vec3d1.multiply(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = Mth.floor(this.xo) != Mth.floor(this.getX()) || Mth.floor(this.yo) != Mth.floor(this.getY()) || Mth.floor(this.zo) != Mth.floor(this.getZ());
            int n = i = flag ? 2 : 40;
            if (this.tickCount % i == 0 && !this.level().isClientSide && this.isMergable()) {
                this.mergeWithNeighbours();
            }
            if (this.age != Short.MIN_VALUE) {
                ++this.age;
            }
            this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
            if (!this.level().isClientSide && (d0 = this.getDeltaMovement().subtract(vec3d).lengthSqr()) > 0.01) {
                this.hasImpulse = true;
            }
            if (!this.level().isClientSide && this.age >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.age = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        if (this.pickupDelay > 0 && this.pickupDelay != Short.MAX_VALUE) {
            --this.pickupDelay;
        }
        if (this.age != Short.MIN_VALUE) {
            ++this.age;
        }
        if (!this.level().isClientSide && this.age >= this.despawnRate) {
            if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                this.age = 0;
                return;
            }
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setUnderwaterMovement() {
        this.setFluidMovement(0.99f);
    }

    private void setUnderLavaMovement() {
        this.setFluidMovement(0.95f);
    }

    private void setFluidMovement(double horizontalMultiplier) {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * horizontalMultiplier, vec3d.y + (double)(vec3d.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.z * horizontalMultiplier);
    }

    private void mergeWithNeighbours() {
        if (this.isMergable()) {
            double radius = this.level().spigotConfig.itemMerge;
            List<ItemEntity> list = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(radius, this.level().paperConfig().entities.behavior.onlyMergeItemsHorizontally ? 0.0 : radius - 0.5, radius), entityitem -> entityitem != this && entityitem.isMergable());
            for (ItemEntity entityitem2 : list) {
                if (!entityitem2.isMergable() || this.level().paperConfig().fixes.fixItemsMergingThroughWalls && this.level().clipDirect(this.position(), entityitem2.position(), CollisionContext.of(this)) == HitResult.Type.BLOCK) continue;
                this.tryToMerge(entityitem2);
                if (!this.isRemoved()) continue;
                break;
            }
        }
    }

    private boolean isMergable() {
        ItemStack itemstack = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < this.despawnRate && itemstack.getCount() < itemstack.getMaxStackSize();
    }

    private void tryToMerge(ItemEntity other) {
        ItemStack itemstack = this.getItem();
        ItemStack itemstack1 = other.getItem();
        if (Objects.equals(this.target, other.target) && ItemEntity.areMergable(itemstack, itemstack1)) {
            ItemEntity.merge(this, itemstack, other, itemstack1);
        }
    }

    public static boolean areMergable(ItemStack stack1, ItemStack stack2) {
        return stack2.getCount() + stack1.getCount() > stack2.getMaxStackSize() ? false : ItemStack.isSameItemSameComponents(stack1, stack2);
    }

    public static ItemStack merge(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j = Math.min(Math.min(stack1.getMaxStackSize(), maxCount) - stack1.getCount(), stack2.getCount());
        ItemStack itemstack2 = stack1.copyWithCount(stack1.getCount() + j);
        stack2.shrink(j);
        return itemstack2;
    }

    private static void merge(ItemEntity targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = ItemEntity.merge(stack1, stack2, 64);
        targetEntity.setItem(itemstack2);
    }

    private static void merge(ItemEntity targetEntity, ItemStack targetStack, ItemEntity sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        ItemEntity.merge(targetEntity, targetStack, sourceStack);
        targetEntity.pickupDelay = Math.max(targetEntity.pickupDelay, sourceEntity.pickupDelay);
        targetEntity.age = Math.min(targetEntity.age, sourceEntity.age);
        if (sourceStack.isEmpty()) {
            sourceEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean fireImmune() {
        return !this.getItem().canBeHurtBy(this.damageSources().inFire()) || super.fireImmune();
    }

    @Override
    protected boolean shouldPlayLavaHurtSound() {
        return this.health <= 0 ? true : this.tickCount % 10 == 0;
    }

    @Override
    public final boolean hurtClient(DamageSource source) {
        return this.isInvulnerableToBase(source) ? false : this.getItem().canBeHurtBy(source);
    }

    @Override
    public final boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (this.immuneToCactus && source.is(DamageTypes.CACTUS) || this.immuneToFire && (source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.IN_FIRE)) || this.immuneToLightning && source.is(DamageTypes.LIGHTNING_BOLT) || this.immuneToExplosion && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        if (this.isInvulnerableToBase(source)) {
            return false;
        }
        if (!world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && source.getEntity() instanceof Mob) {
            return false;
        }
        if (!this.getItem().canBeHurtBy(source)) {
            return false;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - amount);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, source.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return explosion.shouldAffectBlocklikeEntities() ? super.ignoreExplosion(explosion) : true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.putString("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.putShort("Health", (short)this.health);
        nbt.putShort("Age", (short)this.age);
        nbt.putShort("PickupDelay", (short)this.pickupDelay);
        if (this.thrower != null) {
            nbt.putUUID("Thrower", this.thrower);
        }
        if (this.target != null) {
            nbt.putUUID("Owner", this.target);
        }
        if (!this.getItem().isEmpty()) {
            nbt.put("Item", this.getItem().save(this.registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        this.health = nbt.getShort("Health");
        this.age = nbt.getShort("Age");
        if (nbt.contains("PickupDelay")) {
            this.pickupDelay = nbt.getShort("PickupDelay");
        }
        if (nbt.hasUUID("Owner")) {
            this.target = nbt.getUUID("Owner");
        }
        if (nbt.hasUUID("Thrower")) {
            this.thrower = nbt.getUUID("Thrower");
            this.cachedThrower = null;
        }
        if (nbt.contains("Item", 10)) {
            CompoundTag nbttagcompound1 = nbt.getCompound("Item");
            this.setItem(ItemStack.parse(this.registryAccess(), nbttagcompound1).orElse(ItemStack.EMPTY));
        } else {
            this.setItem(ItemStack.EMPTY);
        }
        if (nbt.contains("Paper.FrictionState")) {
            String fs = nbt.getString("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (this.getItem().isEmpty()) {
            this.discard(null);
        }
    }

    @Override
    public void playerTouch(Player player) {
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            int canHold = player.getInventory().canHold(itemstack);
            int remaining = i - canHold;
            boolean flyAtPlayer = false;
            if (this.pickupDelay <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.level().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.take(this, i);
                    }
                    return;
                }
            }
            if (this.pickupDelay <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.setCount(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.setCount(i);
                    if (flyAtPlayer) {
                        player.take(this, i);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((org.bukkit.entity.Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.setCount(i);
                    return;
                }
                ItemStack current = this.getItem();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.setCount(canHold + remaining);
                }
                this.pickupDelay = 0;
            } else if (this.pickupDelay == 0) {
                this.pickupDelay = -1;
            }
            if (this.pickupDelay == 0 && (this.target == null || this.target.equals(player.getUUID())) && player.getInventory().add(itemstack)) {
                if (flyAtPlayer) {
                    player.take(this, i);
                }
                if (itemstack.isEmpty()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get(item), i);
                player.onItemPickup(this);
            }
        }
    }

    @Override
    public Component getName() {
        Component ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? ichatbasecomponent : this.getItem().getItemName();
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition teleportTarget) {
        Entity entity = super.teleport(teleportTarget);
        if (!this.level().isClientSide && entity instanceof ItemEntity) {
            ItemEntity entityitem = (ItemEntity)entity;
            entityitem.mergeWithNeighbours();
        }
        return entity;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM, stack);
        int n = this.despawnRate = this.level().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.level().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.getItem(), this.level().spigotConfig.itemDespawnRate) : this.level().spigotConfig.itemDespawnRate;
        if (this.level().purpurConfig.itemImmuneToCactus.contains(stack.getItem())) {
            this.immuneToCactus = true;
        }
        if (this.level().purpurConfig.itemImmuneToExplosion.contains(stack.getItem())) {
            this.immuneToExplosion = true;
        }
        if (this.level().purpurConfig.itemImmuneToFire.contains(stack.getItem())) {
            this.immuneToFire = true;
        }
        if (this.level().purpurConfig.itemImmuneToLightning.contains(stack.getItem())) {
            this.immuneToLightning = true;
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (DATA_ITEM.equals(data)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    public void setTarget(@Nullable UUID owner) {
        this.target = owner;
    }

    public void setThrower(Entity thrower) {
        this.thrower = thrower.getUUID();
        this.cachedThrower = thrower;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = this.despawnRate - 1;
    }

    public static float getSpin(float f, float f1) {
        return f / 20.0f + f1;
    }

    public ItemEntity copy() {
        return new ItemEntity(this);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return 180.0f - ItemEntity.getSpin((float)this.getAge() + 0.5f, this.bobOffs) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess getSlot(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.of(this::getItem, this::setItem) : super.getSlot(mappedIndex);
    }
}

