/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.creaking;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreakingTransient
extends Creaking {
    public static final int INVULNERABILITY_ANIMATION_DURATION = 8;
    private int invulnerabilityAnimationRemainingTicks;
    @Nullable
    BlockPos homePos;

    public CreakingTransient(EntityType<? extends Creaking> type, Level world) {
        super(type, world);
    }

    public void bindToCreakingHeart(BlockPos heartPos) {
        this.homePos = heartPos;
    }

    @Override
    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (this.level().isClientSide) {
            return super.hurtServer(world, source, amount);
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurtServer(world, source, amount);
        }
        if (!this.isInvulnerableTo(world, source) && this.invulnerabilityAnimationRemainingTicks <= 0) {
            CreakingHeartBlockEntity creakingheartblockentity;
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.level().broadcastEntityEvent(this, (byte)66);
            BlockEntity tileentity = this.level().getBlockEntity(this.homePos);
            if (tileentity instanceof CreakingHeartBlockEntity && (creakingheartblockentity = (CreakingHeartBlockEntity)tileentity).isProtector(this)) {
                if (source.getEntity() instanceof Player) {
                    creakingheartblockentity.creakingHurt();
                }
                this.playHurtSound(source);
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        super.aiStep();
    }

    @Override
    public void tick() {
        CreakingHeartBlockEntity creakingheartblockentity;
        BlockEntity tileentity;
        if (!(this.level().isClientSide || this.homePos != null && (tileentity = this.level().getBlockEntity(this.homePos)) instanceof CreakingHeartBlockEntity && (creakingheartblockentity = (CreakingHeartBlockEntity)tileentity).isProtector(this))) {
            this.setRemoved(Entity.RemovalReason.DISCARDED, null);
            return;
        }
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.playHurtSound(this.damageSources().generic());
        } else {
            super.handleEntityEvent(status);
        }
    }

    private void setupAnimationStates() {
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
    }

    public void tearDown(@Nullable DamageSource damageSource) {
        Entity entity;
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            AABB axisalignedbb = this.getBoundingBox();
            Vec3 vec3d = axisalignedbb.getCenter();
            double d0 = axisalignedbb.getXsize() * 0.3;
            double d1 = axisalignedbb.getYsize() * 0.3;
            double d2 = axisalignedbb.getZsize() * 0.3;
            worldserver.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), vec3d.x, vec3d.y, vec3d.z, 100, d0, d1, d2, 0.0);
            worldserver.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, (BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.ACTIVE)), vec3d.x, vec3d.y, vec3d.z, 10, d0, d1, d2, 0.0);
        }
        this.makeSound(this.getDeathSound());
        if (this.deathScore >= 0 && damageSource != null && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            entityliving.awardKillScore(this, this.deathScore, damageSource);
        }
        this.remove(Entity.RemovalReason.DISCARDED, null);
    }

    @Override
    protected boolean canAddPassenger(Entity passenger) {
        return false;
    }

    @Override
    protected boolean couldAcceptPassenger() {
        return false;
    }

    @Override
    protected void addPassenger(Entity passenger) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    @Override
    public boolean canUsePortal(boolean allowVehicles) {
        return false;
    }

    @Override
    protected PathNavigation createNavigation(Level world) {
        return new CreakingPathNavigation(this, world);
    }

    private class CreakingPathNavigation
    extends GroundPathNavigation {
        CreakingPathNavigation(Creaking creaking, Level world) {
            super(creaking, world);
        }

        @Override
        public void tick() {
            if (CreakingTransient.this.canMove()) {
                super.tick();
            }
        }

        @Override
        protected PathFinder createPathFinder(int range) {
            this.nodeEvaluator = new HomeNodeEvaluator();
            return new PathFinder(this.nodeEvaluator, range);
        }
    }

    private class HomeNodeEvaluator
    extends WalkNodeEvaluator {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        HomeNodeEvaluator() {
        }

        @Override
        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            BlockPos blockposition = CreakingTransient.this.homePos;
            if (blockposition == null) {
                return super.getPathType(context, x, y, z);
            }
            double d0 = blockposition.distSqr(new Vec3i(x, y, z));
            return d0 > 1024.0 && d0 >= blockposition.distSqr(context.mobPosition()) ? PathType.BLOCKED : super.getPathType(context, x, y, z);
        }
    }
}

