/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Explosive;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class LargeFireball
extends Fireball {
    public int explosionPower = 1;

    public LargeFireball(EntityType<? extends LargeFireball> type, Level world) {
        super((EntityType<? extends Fireball>)type, world);
        ServerLevel worldserver;
        this.isIncendiary = world instanceof ServerLevel && worldserver.purpurConfig.fireballsBypassMobGriefing ^ (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public LargeFireball(Level world, LivingEntity owner, Vec3 velocity, int explosionPower) {
        super((EntityType<? extends Fireball>)EntityType.FIREBALL, owner, velocity, world);
        ServerLevel worldserver;
        this.explosionPower = explosionPower;
        this.isIncendiary = world instanceof ServerLevel && worldserver.purpurConfig.fireballsBypassMobGriefing ^ (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            boolean flag = worldserver.purpurConfig.fireballsBypassMobGriefing ^ worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((Explosive)this.getBukkitEntity());
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.MOB);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = entityHitResult.getEntity();
            Entity entity1 = this.getOwner();
            DamageSource damagesource = this.damageSources().fireball(this, entity1);
            entity.hurtServer(worldserver, damagesource, 6.0f);
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ExplosionPower", 99)) {
            byte by = nbt.getByte("ExplosionPower");
            this.explosionPower = by;
            this.bukkitYield = by;
        }
    }
}

