/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class ProjectileUtil {
    private static final float DEFAULT_ENTITY_HIT_RESULT_MARGIN = 0.3f;

    public static HitResult getHitResultOnMoveVector(Entity entity, Predicate<Entity> predicate) {
        Vec3 vec3 = entity.getDeltaMovement();
        Level level = entity.level();
        Vec3 vec32 = entity.position();
        return ProjectileUtil.getHitResult(vec32, entity, predicate, vec3, level, 0.3f, ClipContext.Block.COLLIDER);
    }

    public static HitResult getHitResultOnMoveVector(Entity entity, Predicate<Entity> predicate, ClipContext.Block raycastShapeType) {
        Vec3 vec3 = entity.getDeltaMovement();
        Level level = entity.level();
        Vec3 vec32 = entity.position();
        return ProjectileUtil.getHitResult(vec32, entity, predicate, vec3, level, 0.3f, raycastShapeType);
    }

    public static HitResult getHitResultOnViewVector(Entity entity, Predicate<Entity> predicate, double range) {
        Vec3 vec3 = entity.getViewVector(0.0f).scale(range);
        Level level = entity.level();
        Vec3 vec32 = entity.getEyePosition();
        return ProjectileUtil.getHitResult(vec32, entity, predicate, vec3, level, 0.0f, ClipContext.Block.COLLIDER);
    }

    private static HitResult getHitResult(Vec3 pos, Entity entity, Predicate<Entity> predicate, Vec3 velocity, Level world, float margin, ClipContext.Block raycastShapeType) {
        EntityHitResult hitResult2;
        Vec3 vec3 = pos.add(velocity);
        HitResult hitResult = world.clipIncludingBorder(new ClipContext(pos, vec3, raycastShapeType, ClipContext.Fluid.NONE, entity));
        if (((HitResult)hitResult).getType() != HitResult.Type.MISS) {
            vec3 = hitResult.getLocation();
        }
        if ((hitResult2 = ProjectileUtil.getEntityHitResult(world, entity, pos, vec3, entity.getBoundingBox().expandTowards(velocity).inflate(1.0), predicate, margin)) != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate, double maxDistance) {
        Level level = entity.level();
        double d = maxDistance;
        Entity entity2 = null;
        Vec3 vec3 = null;
        for (Entity entity3 : level.getEntities(entity, box, predicate)) {
            Vec3 vec32;
            double e;
            AABB aABB = entity3.getBoundingBox().inflate(entity3.getPickRadius());
            Optional<Vec3> optional = aABB.clip(min, max);
            if (aABB.contains(min)) {
                if (!(d >= 0.0)) continue;
                entity2 = entity3;
                vec3 = optional.orElse(min);
                d = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((e = min.distanceToSqr(vec32 = optional.get())) < d) && d != 0.0) continue;
            if (entity3.getRootVehicle() == entity.getRootVehicle()) {
                if (d != 0.0) continue;
                entity2 = entity3;
                vec3 = vec32;
                continue;
            }
            entity2 = entity3;
            vec3 = vec32;
            d = e;
        }
        if (entity2 == null) {
            return null;
        }
        return new EntityHitResult(entity2, vec3);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level world, Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate) {
        return ProjectileUtil.getEntityHitResult(world, entity, min, max, box, predicate, 0.3f);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level world, Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate, float margin) {
        double d = Double.MAX_VALUE;
        Optional<Object> optional = Optional.empty();
        Entity entity2 = null;
        for (Entity entity3 : world.getEntities(entity, box, predicate)) {
            double e;
            AABB aABB = entity3.getBoundingBox().inflate(margin);
            Optional<Vec3> optional2 = aABB.clip(min, max);
            if (!optional2.isPresent() || !((e = min.distanceToSqr(optional2.get())) < d)) continue;
            entity2 = entity3;
            d = e;
            optional = optional2;
        }
        if (entity2 == null) {
            return null;
        }
        return new EntityHitResult(entity2, (Vec3)optional.get());
    }

    public static void rotateTowardsMovement(Entity entity, float delta) {
        Vec3 vec3 = entity.getDeltaMovement();
        if (vec3.lengthSqr() == 0.0) {
            return;
        }
        double d = vec3.horizontalDistance();
        entity.setYRot((float)(Mth.atan2(vec3.z, vec3.x) * 57.2957763671875) + 90.0f);
        entity.setXRot((float)(Mth.atan2(d, vec3.y) * 57.2957763671875) - 90.0f);
        while (entity.getXRot() - entity.xRotO < -180.0f) {
            entity.xRotO -= 360.0f;
        }
        while (entity.getXRot() - entity.xRotO >= 180.0f) {
            entity.xRotO += 360.0f;
        }
        while (entity.getYRot() - entity.yRotO < -180.0f) {
            entity.yRotO -= 360.0f;
        }
        while (entity.getYRot() - entity.yRotO >= 180.0f) {
            entity.yRotO += 360.0f;
        }
        entity.setXRot(Mth.lerp(delta, entity.xRotO, entity.getXRot()));
        entity.setYRot(Mth.lerp(delta, entity.yRotO, entity.getYRot()));
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity entity, Item item) {
        return entity.getMainHandItem().is(item) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static AbstractArrow getMobArrow(LivingEntity entity, ItemStack stack, float damageModifier, @Nullable ItemStack bow) {
        ArrowItem arrowItem = (ArrowItem)(stack.getItem() instanceof ArrowItem ? stack.getItem() : Items.ARROW);
        AbstractArrow abstractArrow = arrowItem.createArrow(entity.level(), stack, entity, bow);
        abstractArrow.setBaseDamageFromMob(damageModifier);
        return abstractArrow;
    }
}

