/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class SmallFireball
extends Fireball {
    public SmallFireball(EntityType<? extends SmallFireball> type, Level world) {
        super((EntityType<? extends Fireball>)type, world);
    }

    public SmallFireball(Level world, LivingEntity owner, Vec3 velocity) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, owner, velocity, world);
        if (this.getOwner() != null && this.getOwner() instanceof Mob) {
            ServerLevel worldserver;
            this.isIncendiary = world instanceof ServerLevel && worldserver.purpurConfig.fireballsBypassMobGriefing ^ (worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
    }

    public SmallFireball(Level world, double x, double y, double z, Vec3 velocity) {
        super((EntityType<? extends Fireball>)EntityType.SMALL_FIREBALL, x, y, z, velocity, world);
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            DamageSource damagesource;
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = entityHitResult.getEntity();
            Entity entity1 = this.getOwner();
            int i = entity.getRemainingFireTicks();
            EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)((Projectile)this.getBukkitEntity()), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5.0f);
            entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                entity.igniteForSeconds(event.getDuration(), false);
            }
            if (!entity.hurtServer(worldserver, damagesource = this.damageSources().fireball(this, entity1), 5.0f)) {
                entity.setRemainingFireTicks(i);
            } else {
                EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = this.getOwner();
            if (this.isIncendiary) {
                BlockPos blockposition = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                if (this.level().isEmptyBlock(blockposition) && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                    this.level().setBlockAndUpdate(blockposition, BaseFireBlock.getState(this.level(), blockposition));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }
}

