/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class ThrownEgg
extends ThrowableItemProjectile {
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);

    public ThrownEgg(EntityType<? extends ThrownEgg> type, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)type, world);
    }

    public ThrownEgg(Level world, LivingEntity owner, ItemStack stack) {
        super(EntityType.EGG, owner, world, stack);
    }

    public ThrownEgg(Level world, double x, double y, double z, ItemStack stack) {
        super(EntityType.EGG, x, y, z, world, stack);
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        entityHitResult.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            ThrownEggHatchEvent event;
            boolean hatching = this.random.nextInt(8) == 0;
            int b0 = 1;
            if (this.random.nextInt(32) == 0) {
                b0 = 4;
            }
            org.bukkit.entity.EntityType hatchingType = org.bukkit.entity.EntityType.CHICKEN;
            Entity shooter = this.getOwner();
            if (!hatching) {
                b0 = 0;
            }
            if (shooter instanceof ServerPlayer) {
                event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)b0, hatchingType);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                b0 = event.getNumHatches();
                hatching = event.isHatching();
                hatchingType = event.getHatchingType();
                if (!hatching) {
                    b0 = 0;
                }
            }
            event = new ThrownEggHatchEvent((Egg)this.getBukkitEntity(), hatching, (byte)b0, hatchingType);
            event.callEvent();
            hatching = event.isHatching();
            b0 = hatching ? event.getNumHatches() : (byte)0;
            hatchingType = event.getHatchingType();
            for (int i = 0; i < b0; ++i) {
                Entity entitychicken = this.level().getWorld().makeEntity(new Location((World)this.level().getWorld(), this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f), hatchingType.getEntityClass());
                if (entitychicken == null) continue;
                if (entitychicken.getBukkitEntity() instanceof Ageable) {
                    ((Ageable)entitychicken.getBukkitEntity()).setBaby();
                }
                entitychicken.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                if (!entitychicken.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                this.level().addFreshEntity(entitychicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EGG;
    }
}

