/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PathfindToRaidGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class Raider
extends PatrollingMonster {
    protected static final EntityDataAccessor<Boolean> IS_CELEBRATING = SynchedEntityData.defineId(Raider.class, EntityDataSerializers.BOOLEAN);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = entityitem -> !entityitem.hasPickUpDelay() && entityitem.isAlive() && ItemStack.matches(entityitem.getItem(), Raid.getOminousBannerInstance(entityitem.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
    @Nullable
    protected Raid raid;
    private int wave;
    private boolean canJoinRaid;
    private int ticksOutsideRaid;

    protected Raider(EntityType<? extends Raider> type, Level world) {
        super((EntityType<? extends PatrollingMonster>)type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new ObtainRaidLeaderBannerGoal(this, this));
        this.goalSelector.addGoal(3, new PathfindToRaidGoal<Raider>(this));
        this.goalSelector.addGoal(4, new RaiderMoveThroughVillageGoal(this, 1.05f, 1));
        this.goalSelector.addGoal(5, new RaiderCelebration(this));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_CELEBRATING, false);
    }

    public abstract void applyRaidBuffs(ServerLevel var1, int var2, boolean var3);

    public boolean canJoinRaid() {
        return this.canJoinRaid;
    }

    public void setCanJoinRaid(boolean ableToJoinRaid) {
        this.canJoinRaid = ableToJoinRaid;
    }

    @Override
    public void aiStep() {
        if (this.level() instanceof ServerLevel && this.isAlive()) {
            Raid raid = this.getCurrentRaid();
            if (this.canJoinRaid()) {
                if (raid == null) {
                    Raid raid1;
                    if (this.level().getGameTime() % 20L == 0L && (raid1 = ((ServerLevel)this.level()).getRaidAt(this.blockPosition())) != null && Raids.canJoinRaid(this, raid1)) {
                        raid1.joinRaid(raid1.getGroupsSpawned(), this, null, true);
                    }
                } else {
                    LivingEntity entityliving = this.getTarget();
                    if (entityliving != null && (entityliving.getType() == EntityType.PLAYER || entityliving.getType() == EntityType.IRON_GOLEM)) {
                        this.noActionTime = 0;
                    }
                }
            }
        }
        super.aiStep();
    }

    @Override
    protected void updateNoActionTime() {
        this.noActionTime += 2;
    }

    @Override
    public void die(DamageSource damageSource) {
        if (this.level() instanceof ServerLevel) {
            Entity entity = damageSource.getEntity();
            Raid raid = this.getCurrentRaid();
            if (raid != null) {
                if (this.isPatrolLeader()) {
                    raid.removeLeader(this.getWave());
                }
                if (entity != null && entity.getType() == EntityType.PLAYER) {
                    raid.addHeroOfTheVillage(entity);
                }
                raid.removeFromRaid(this, false);
            }
        }
        super.die(damageSource);
    }

    @Override
    public boolean canJoinPatrol() {
        return !this.hasActiveRaid();
    }

    public void setCurrentRaid(@Nullable Raid raid) {
        this.raid = raid;
    }

    @Nullable
    public Raid getCurrentRaid() {
        return this.raid;
    }

    public boolean isCaptain() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
        boolean flag = !itemstack.isEmpty() && ItemStack.matches(itemstack, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        boolean flag1 = this.isPatrolLeader();
        return flag && flag1;
    }

    public boolean hasRaid() {
        Level world = this.level();
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel worldserver = (ServerLevel)world;
        return this.getCurrentRaid() != null || worldserver.getRaidAt(this.blockPosition()) != null;
    }

    public boolean hasActiveRaid() {
        return this.getCurrentRaid() != null && this.getCurrentRaid().isActive();
    }

    public void setWave(int wave) {
        this.wave = wave;
    }

    public int getWave() {
        return this.wave;
    }

    public boolean isCelebrating() {
        return this.entityData.get(IS_CELEBRATING);
    }

    public void setCelebrating(boolean celebrating) {
        this.entityData.set(IS_CELEBRATING, celebrating);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Wave", this.wave);
        nbt.putBoolean("CanJoinRaid", this.canJoinRaid);
        if (this.raid != null) {
            nbt.putInt("RaidId", this.raid.getId());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.wave = nbt.getInt("Wave");
        this.canJoinRaid = nbt.getBoolean("CanJoinRaid");
        if (nbt.contains("RaidId", 3)) {
            if (this.level() instanceof ServerLevel) {
                this.raid = ((ServerLevel)this.level()).getRaids().get(nbt.getInt("RaidId"));
            }
            if (this.raid != null) {
                this.raid.addWaveMob(this.wave, this, false);
                if (this.isPatrolLeader()) {
                    this.raid.setLeader(this.wave, this);
                }
            }
        }
    }

    @Override
    protected void pickUpItem(ServerLevel world, ItemEntity itemEntity) {
        boolean flag;
        ItemStack itemstack = itemEntity.getItem();
        boolean bl = flag = this.hasActiveRaid() && this.getCurrentRaid().getLeader(this.getWave()) != null;
        if (this.hasActiveRaid() && !flag && ItemStack.matches(itemstack, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, itemEntity, 0, false).isCancelled()) {
                return;
            }
            EquipmentSlot enumitemslot = EquipmentSlot.HEAD;
            ItemStack itemstack1 = this.getItemBySlot(enumitemslot);
            double d0 = this.getEquipmentDropChance(enumitemslot);
            if (!itemstack1.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.spawnAtLocation(world, itemstack1);
                this.forceDrops = false;
            }
            this.onItemPickup(itemEntity);
            this.setItemSlot(enumitemslot, itemstack);
            this.take(itemEntity, itemstack.getCount());
            itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.getCurrentRaid().setLeader(this.getWave(), this);
            this.setPatrolLeader(true);
        } else {
            super.pickUpItem(world, itemEntity);
        }
    }

    @Override
    public boolean removeWhenFarAway(double distanceSquared) {
        return this.getCurrentRaid() == null ? super.removeWhenFarAway(distanceSquared) : false;
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getCurrentRaid() != null;
    }

    public int getTicksOutsideRaid() {
        return this.ticksOutsideRaid;
    }

    public void setTicksOutsideRaid(int outOfRaidCounter) {
        this.ticksOutsideRaid = outOfRaidCounter;
    }

    @Override
    public boolean hurtServer(ServerLevel world, DamageSource source, float amount) {
        if (this.hasActiveRaid()) {
            this.getCurrentRaid().updateBossbar();
        }
        return super.hurtServer(world, source, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setCanJoinRaid(this.getType() != EntityType.WITCH || spawnReason != EntitySpawnReason.NATURAL);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public abstract SoundEvent getCelebrateSound();

    public static class ObtainRaidLeaderBannerGoal<T extends Raider>
    extends Goal {
        private final T mob;
        private Int2LongOpenHashMap unreachableBannerCache = new Int2LongOpenHashMap();
        @Nullable
        private Path pathToBanner;
        @Nullable
        private ItemEntity pursuedBannerItemEntity;
        final /* synthetic */ Raider this$0;

        public ObtainRaidLeaderBannerGoal(T entityraider) {
            this.this$0 = this$0;
            this.mob = entityraider;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            if (this.cannotPickUpBanner()) {
                return false;
            }
            Int2LongOpenHashMap int2longopenhashmap = new Int2LongOpenHashMap();
            double d0 = this.this$0.getAttributeValue(Attributes.FOLLOW_RANGE);
            List<ItemEntity> list = ((Entity)this.mob).level().getEntitiesOfClass(ItemEntity.class, ((Entity)this.mob).getBoundingBox().inflate(d0, 8.0, d0), ALLOWED_ITEMS);
            for (ItemEntity entityitem : list) {
                long i = this.unreachableBannerCache.getOrDefault(entityitem.getId(), Long.MIN_VALUE);
                if (this.this$0.level().getGameTime() < i) {
                    int2longopenhashmap.put(entityitem.getId(), i);
                    continue;
                }
                Path pathentity = ((Mob)this.mob).getNavigation().createPath(entityitem, 1);
                if (pathentity != null && pathentity.canReach()) {
                    this.pathToBanner = pathentity;
                    this.pursuedBannerItemEntity = entityitem;
                    return true;
                }
                int2longopenhashmap.put(entityitem.getId(), this.this$0.level().getGameTime() + 600L);
            }
            this.unreachableBannerCache = int2longopenhashmap;
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return this.pursuedBannerItemEntity != null && this.pathToBanner != null ? (this.pursuedBannerItemEntity.isRemoved() ? false : (this.pathToBanner.isDone() ? false : !this.cannotPickUpBanner())) : false;
        }

        private boolean cannotPickUpBanner() {
            if (!((Entity)this.mob).level().purpurConfig.pillagerBypassMobGriefing == !ObtainRaidLeaderBannerGoal.getServerLevel(this.mob).getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || !((Mob)this.mob).canPickUpLoot()) {
                return false;
            }
            if (!((Raider)this.mob).hasActiveRaid()) {
                return true;
            }
            if (((Raider)this.mob).getCurrentRaid().isOver()) {
                return true;
            }
            if (!((PatrollingMonster)this.mob).canBeLeader()) {
                return true;
            }
            if (ItemStack.matches(((Mob)this.mob).getItemBySlot(EquipmentSlot.HEAD), Raid.getOminousBannerInstance(((Entity)this.mob).registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
                return true;
            }
            Raider entityraider = this.this$0.raid.getLeader(((Raider)this.mob).getWave());
            return entityraider != null && entityraider.isAlive();
        }

        @Override
        public void start() {
            ((Mob)this.mob).getNavigation().moveTo(this.pathToBanner, (double)1.15f);
        }

        @Override
        public void stop() {
            this.pathToBanner = null;
            this.pursuedBannerItemEntity = null;
        }

        @Override
        public void tick() {
            if (this.pursuedBannerItemEntity != null && this.pursuedBannerItemEntity.closerThan((Entity)this.mob, 1.414)) {
                ((Raider)this.mob).pickUpItem(ObtainRaidLeaderBannerGoal.getServerLevel(this.this$0.level()), this.pursuedBannerItemEntity);
            }
        }
    }

    private static class RaiderMoveThroughVillageGoal
    extends Goal {
        private final Raider raider;
        private final double speedModifier;
        private BlockPos poiPos;
        private final List<BlockPos> visited = Lists.newArrayList();
        private final int distanceToPoi;
        private boolean stuck;

        public RaiderMoveThroughVillageGoal(Raider raider, double speed, int distance) {
            this.raider = raider;
            this.speedModifier = speed;
            this.distanceToPoi = distance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            this.updateVisited();
            return this.isValidRaid() && this.hasSuitablePoi() && this.raider.getTarget() == null;
        }

        private boolean isValidRaid() {
            return this.raider.hasActiveRaid() && !this.raider.getCurrentRaid().isOver();
        }

        private boolean hasSuitablePoi() {
            ServerLevel worldserver = (ServerLevel)this.raider.level();
            BlockPos blockposition = this.raider.blockPosition();
            Optional<BlockPos> optional = worldserver.getPoiManager().getRandom(holder -> holder.is(PoiTypes.HOME), this::hasNotVisited, PoiManager.Occupancy.ANY, blockposition, 48, this.raider.random);
            if (optional.isEmpty()) {
                return false;
            }
            this.poiPos = optional.get().immutable();
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            return this.raider.getNavigation().isDone() ? false : this.raider.getTarget() == null && !this.poiPos.closerToCenterThan(this.raider.position(), this.raider.getBbWidth() + (float)this.distanceToPoi) && !this.stuck;
        }

        @Override
        public void stop() {
            if (this.poiPos.closerToCenterThan(this.raider.position(), this.distanceToPoi)) {
                this.visited.add(this.poiPos);
            }
        }

        @Override
        public void start() {
            super.start();
            this.raider.setNoActionTime(0);
            this.raider.getNavigation().moveTo(this.poiPos.getX(), this.poiPos.getY(), this.poiPos.getZ(), this.speedModifier);
            this.stuck = false;
        }

        @Override
        public void tick() {
            if (this.raider.getNavigation().isDone()) {
                Vec3 vec3d = Vec3.atBottomCenterOf(this.poiPos);
                Vec3 vec3d1 = DefaultRandomPos.getPosTowards(this.raider, 16, 7, vec3d, 0.3141592741012573);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.getPosTowards(this.raider, 8, 7, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.stuck = true;
                    return;
                }
                this.raider.getNavigation().moveTo(vec3d1.x, vec3d1.y, vec3d1.z, this.speedModifier);
            }
        }

        private boolean hasNotVisited(BlockPos pos) {
            BlockPos blockposition1;
            Iterator<BlockPos> iterator = this.visited.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!Objects.equals(pos, blockposition1 = iterator.next()));
            return false;
        }

        private void updateVisited() {
            if (this.visited.size() > 2) {
                this.visited.remove(0);
            }
        }
    }

    public class RaiderCelebration
    extends Goal {
        private final Raider mob;

        RaiderCelebration(Raider entityraider) {
            this.mob = entityraider;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            Raid raid = this.mob.getCurrentRaid();
            return this.mob.isAlive() && this.mob.getTarget() == null && raid != null && raid.isLoss();
        }

        @Override
        public void start() {
            this.mob.setCelebrating(true);
            super.start();
        }

        @Override
        public void stop() {
            this.mob.setCelebrating(false);
            super.stop();
        }

        @Override
        public void tick() {
            if (!this.mob.isSilent() && this.mob.random.nextInt(this.adjustedTickDelay(100)) == 0) {
                Raider.this.makeSound(Raider.this.getCelebrateSound());
            }
            if (!this.mob.isPassenger() && this.mob.random.nextInt(this.adjustedTickDelay(50)) == 0) {
                this.mob.getJumpControl().jump();
            }
            super.tick();
        }
    }

    public class HoldGroundAttackGoal
    extends Goal {
        private final Raider mob;
        private final float hostileRadiusSqr;
        public final TargetingConditions shoutTargeting = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        public HoldGroundAttackGoal(Raider this$0, AbstractIllager entityillagerabstract, float f) {
            this.mob = entityillagerabstract;
            this.hostileRadiusSqr = f * f;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            LivingEntity entityliving = this.mob.getLastHurtByMob();
            return this.mob.getCurrentRaid() == null && this.mob.isPatrolling() && this.mob.getTarget() != null && !this.mob.isAggressive() && (entityliving == null || entityliving.getType() != EntityType.PLAYER);
        }

        @Override
        public void start() {
            super.start();
            this.mob.getNavigation().stop();
            List<Raider> list = HoldGroundAttackGoal.getServerLevel(this.mob).getNearbyEntities(Raider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (Raider entityraider : list) {
                entityraider.setTarget(this.mob.getTarget(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        @Override
        public void stop() {
            super.stop();
            LivingEntity entityliving = this.mob.getTarget();
            if (entityliving != null) {
                List<Raider> list = HoldGroundAttackGoal.getServerLevel(this.mob).getNearbyEntities(Raider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (Raider entityraider : list) {
                    entityraider.setTarget(this.mob.getTarget(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    entityraider.setAggressive(true);
                }
                this.mob.setAggressive(true);
            }
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            LivingEntity entityliving = this.mob.getTarget();
            if (entityliving != null) {
                if (this.mob.distanceToSqr(entityliving) > (double)this.hostileRadiusSqr) {
                    this.mob.getLookControl().setLookAt(entityliving, 30.0f, 30.0f);
                    if (this.mob.random.nextInt(50) == 0) {
                        this.mob.playAmbientSound();
                    }
                } else {
                    this.mob.setAggressive(true);
                }
                super.tick();
            }
        }
    }
}

