/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Map;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean onRails;
    private boolean flipped;
    private final MinecartBehavior behavior;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), enummap -> {
        Vec3i baseblockposition = Direction.WEST.getUnitVec3i();
        Vec3i baseblockposition1 = Direction.EAST.getUnitVec3i();
        Vec3i baseblockposition2 = Direction.NORTH.getUnitVec3i();
        Vec3i baseblockposition3 = Direction.SOUTH.getUnitVec3i();
        Vec3i baseblockposition4 = baseblockposition.below();
        Vec3i baseblockposition5 = baseblockposition1.below();
        Vec3i baseblockposition6 = baseblockposition2.below();
        Vec3i baseblockposition7 = baseblockposition3.below();
        enummap.put(RailShape.NORTH_SOUTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition3));
        enummap.put(RailShape.EAST_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition1));
        enummap.put(RailShape.ASCENDING_EAST, Pair.of((Object)baseblockposition4, (Object)baseblockposition1));
        enummap.put(RailShape.ASCENDING_WEST, Pair.of((Object)baseblockposition, (Object)baseblockposition5));
        enummap.put(RailShape.ASCENDING_NORTH, Pair.of((Object)baseblockposition2, (Object)baseblockposition7));
        enummap.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)baseblockposition6, (Object)baseblockposition3));
        enummap.put(RailShape.SOUTH_EAST, Pair.of((Object)baseblockposition3, (Object)baseblockposition1));
        enummap.put(RailShape.SOUTH_WEST, Pair.of((Object)baseblockposition3, (Object)baseblockposition));
        enummap.put(RailShape.NORTH_WEST, Pair.of((Object)baseblockposition2, (Object)baseblockposition));
        enummap.put(RailShape.NORTH_EAST, Pair.of((Object)baseblockposition2, (Object)baseblockposition1));
    });
    public boolean slowWhenEmpty = true;
    private double derailedX = 0.5;
    private double derailedY = 0.5;
    private double derailedZ = 0.5;
    private double flyingX = 0.95;
    private double flyingY = 0.95;
    private double flyingZ = 0.95;
    public Double maxSpeed;
    public double storedMaxSpeed;
    public boolean isNewBehavior;
    public TriState frictionState = TriState.NOT_SET;
    private Double lastSpeed;

    protected AbstractMinecart(EntityType<?> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
        if (AbstractMinecart.useExperimentalMovement(world)) {
            this.behavior = new NewMinecartBehavior(this);
            this.isNewBehavior = true;
        } else {
            this.behavior = new OldMinecartBehavior(this);
            this.isNewBehavior = false;
            this.storedMaxSpeed = world.purpurConfig.minecartMaxSpeed;
            this.maxSpeed = this.storedMaxSpeed;
        }
    }

    protected AbstractMinecart(EntityType<?> type, Level world, double x, double y, double z) {
        this(type, world);
        this.setInitialPos(x, y, z);
    }

    public void setInitialPos(double x, double y, double z) {
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @Nullable
    public static <T extends AbstractMinecart> T createMinecart(Level world, double x, double y, double z, EntityType<T> type, EntitySpawnReason reason, ItemStack stack, @Nullable Player player) {
        AbstractMinecart t0 = (AbstractMinecart)type.create(world, reason);
        if (t0 != null) {
            t0.setInitialPos(x, y, z);
            EntityType.createDefaultStackConfig(world, stack, player).accept(t0);
            MinecartBehavior minecartbehavior = t0.getBehavior();
            if (minecartbehavior instanceof NewMinecartBehavior) {
                NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                BlockPos blockposition = t0.getCurrentBlockPosOrRailBelow();
                BlockState iblockdata = world.getBlockState(blockposition);
                newminecartbehavior.adjustToRails(blockposition, iblockdata, true);
            }
        }
        return (T)t0;
    }

    public MinecartBehavior getBehavior() {
        return this.behavior;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        builder.define(DATA_ID_DISPLAY_OFFSET, 6);
        builder.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity other) {
        boolean collides = AbstractBoat.canVehicleCollide(this, other);
        if (!collides) {
            return false;
        }
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)other.getBukkitEntity());
        return collisionEvent.callEvent();
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return true;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis portalAxis, BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(portalAxis, portalRect));
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        boolean flag = passenger instanceof Villager || passenger instanceof WanderingTrader;
        return flag ? LOWERED_PASSENGER_ATTACHMENT : super.getPassengerAttachmentPoint(passenger, dimensions, scaleFactor);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction enumdirection = this.getMotionDirection();
        if (enumdirection.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(passenger);
        }
        int[][] aint = DismountHelper.offsetsForDirection(enumdirection);
        BlockPos blockposition = this.blockPosition();
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> immutablelist = passenger.getDismountPoses();
        for (Pose entitypose : immutablelist) {
            EntityDimensions entitysize = passenger.getDimensions(entitypose);
            float f = Math.min(entitysize.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableiterator1 = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)entitypose)).iterator();
            while (unmodifiableiterator1.hasNext()) {
                int i = (Integer)unmodifiableiterator1.next();
                int[][] aint1 = aint;
                int j = aint.length;
                for (int k = 0; k < j; ++k) {
                    int[] aint2 = aint1[k];
                    blockposition_mutableblockposition.set(blockposition.getX() + aint2[0], blockposition.getY() + i, blockposition.getZ() + aint2[1]);
                    double d0 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level(), blockposition_mutableblockposition), () -> DismountHelper.nonClimbableShape(this.level(), (BlockPos)blockposition_mutableblockposition.below()));
                    if (!DismountHelper.isBlockFloorValid(d0)) continue;
                    AABB axisalignedbb = new AABB(-f, 0.0, -f, f, entitysize.height(), f);
                    Vec3 vec3d = Vec3.upFromBottomCenterOf(blockposition_mutableblockposition, d0);
                    if (!DismountHelper.canDismountTo(this.level(), passenger, axisalignedbb.move(vec3d))) continue;
                    passenger.setPose(entitypose);
                    return vec3d;
                }
            }
        }
        double d1 = this.getBoundingBox().maxY;
        blockposition_mutableblockposition.set((double)blockposition.getX(), d1, (double)blockposition.getZ());
        for (Pose entitypose1 : immutablelist) {
            int l;
            double d3;
            double d2 = passenger.getDimensions(entitypose1).height();
            if (!(d1 + d2 <= (d3 = DismountHelper.findCeilingFrom(blockposition_mutableblockposition, l = Mth.ceil(d1 - (double)blockposition_mutableblockposition.getY() + d2), blockposition1 -> this.level().getBlockState((BlockPos)blockposition1).getCollisionShape(this.level(), (BlockPos)blockposition1))))) continue;
            passenger.setPose(entitypose1);
            break;
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState iblockdata = this.level().getBlockState(this.blockPosition());
        return iblockdata.is(BlockTags.RAILS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    public static Pair<Vec3i, Vec3i> exits(RailShape shape) {
        return EXITS.get(shape);
    }

    @Override
    public Direction getMotionDirection() {
        return this.behavior.getMotionDirection();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        if (!this.isNewBehavior && this.storedMaxSpeed != this.level().purpurConfig.minecartMaxSpeed) {
            this.storedMaxSpeed = this.level().purpurConfig.minecartMaxSpeed;
            this.maxSpeed = this.storedMaxSpeed;
        }
        double prevX = this.getX();
        double prevY = this.getY();
        double prevZ = this.getZ();
        float prevYaw = this.getYRot();
        float prevPitch = this.getXRot();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.behavior.tick();
        CraftWorld bworld = this.level().getWorld();
        Location from = new Location((World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = CraftLocation.toBukkit(this.position(), (World)bworld, this.getYRot(), this.getXRot());
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (!from.equals((Object)to)) {
            this.level().getCraftServer().getPluginManager().callEvent((Event)new VehicleMoveEvent(vehicle, from, to));
        }
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.firstTick = false;
    }

    public boolean isFirstTick() {
        return this.firstTick;
    }

    public BlockPos getCurrentBlockPosOrRailBelow() {
        int i = Mth.floor(this.getX());
        int j = Mth.floor(this.getY());
        int k = Mth.floor(this.getZ());
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            double d0 = this.getY() - 0.1 - (double)1.0E-5f;
            if (this.level().getBlockState(BlockPos.containing(i, d0, k)).is(BlockTags.RAILS)) {
                j = Mth.floor(d0);
            }
        } else if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        return new BlockPos(i, j, k);
    }

    protected double getMaxSpeed(ServerLevel world) {
        return this.behavior.getMaxSpeed(world);
    }

    public void activateMinecart(int x, int y, int z, boolean powered) {
    }

    @Override
    public void lerpPositionAndRotationStep(int step, double x, double y, double z, double yaw, double pitch) {
        super.lerpPositionAndRotationStep(step, x, y, z, yaw, pitch);
    }

    @Override
    public void applyGravity() {
        super.applyGravity();
    }

    @Override
    public void reapplyPosition() {
        super.reapplyPosition();
    }

    @Override
    public boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    @Override
    public Vec3 getKnownMovement() {
        return this.behavior.getKnownMovement(super.getKnownMovement());
    }

    @Override
    public void cancelLerp() {
        this.behavior.cancelLerp();
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.behavior.lerpTo(x, y, z, yaw, pitch, interpolationSteps);
    }

    @Override
    public double lerpTargetX() {
        return this.behavior.lerpTargetX();
    }

    @Override
    public double lerpTargetY() {
        return this.behavior.lerpTargetY();
    }

    @Override
    public double lerpTargetZ() {
        return this.behavior.lerpTargetZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.behavior.lerpTargetXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.behavior.lerpTargetYRot();
    }

    @Override
    public void lerpMotion(double x, double y, double z) {
        this.behavior.lerpMotion(x, y, z);
    }

    protected void moveAlongTrack(ServerLevel world) {
        this.behavior.moveAlongTrack(world);
    }

    public double getControllableSpeed() {
        BlockState blockState = this.level().getBlockState(this.blockPosition());
        if (!blockState.isSolid()) {
            blockState = this.level().getBlockState(this.blockPosition().relative(Direction.DOWN));
        }
        Double speed = this.level().purpurConfig.minecartControllableBlockSpeeds.get(blockState.getBlock());
        if (!blockState.isSolid()) {
            speed = this.lastSpeed;
        }
        if (speed == null) {
            speed = this.level().purpurConfig.minecartControllableBaseSpeed;
        }
        this.lastSpeed = speed;
        return this.lastSpeed;
    }

    protected void comeOffTrack(ServerLevel world) {
        double d0 = this.getMaxSpeed(world);
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp(vec3d.x, -d0, d0), vec3d.y, Mth.clamp(vec3d.z, -d0, d0));
        if (this.level().purpurConfig.minecartControllable && !this.isInWater() && !this.isInLava() && !this.passengers.isEmpty()) {
            Entity passenger = (Entity)this.passengers.get(0);
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                if (player.jumping && this.onGround) {
                    this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, this.level().purpurConfig.minecartControllableHopBoost, this.getDeltaMovement().z));
                }
                if (player.zza != 0.0f) {
                    Vector velocity = player.getBukkitEntity().getEyeLocation().getDirection().normalize().multiply(this.getControllableSpeed());
                    if ((double)player.zza < 0.0) {
                        velocity.multiply(-0.5);
                    }
                    this.setDeltaMovement(new Vec3(velocity.getX(), this.getDeltaMovement().y, velocity.getZ()));
                }
                this.setYRot(passenger.getYRot() - 90.0f);
                this.maxUpStep = this.level().purpurConfig.minecartControllableStepHeight;
            } else {
                this.maxUpStep = 0.0f;
            }
        } else {
            this.maxUpStep = 0.0f;
        }
        if (this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.derailedX, this.getDeltaMovement().y * this.derailedY, this.getDeltaMovement().z * this.derailedZ));
        } else if (this.level().purpurConfig.minecartControllable) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.derailedX, this.getDeltaMovement().y, this.getDeltaMovement().z * this.derailedZ));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x * this.flyingX, this.getDeltaMovement().y * this.flyingY, this.getDeltaMovement().z * this.flyingZ));
        }
    }

    protected double makeStepAlongTrack(BlockPos pos, RailShape shape, double remainingMovement) {
        return this.behavior.stepAlongTrack(pos, shape, remainingMovement);
    }

    @Override
    public void move(MoverType type, Vec3 movement) {
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec3d1 = this.position().add(movement);
            super.move(type, movement);
            boolean flag = this.behavior.pushAndPickupEntities();
            if (flag) {
                super.move(type, vec3d1.subtract(this.position()));
            }
            if (type.equals((Object)MoverType.PISTON)) {
                this.onRails = false;
            }
        } else {
            super.move(type, movement);
            this.applyEffectsFromBlocks();
        }
    }

    @Override
    public void applyEffectsFromBlocks() {
        if (!AbstractMinecart.useExperimentalMovement(this.level())) {
            this.applyEffectsFromBlocks(this.position(), this.position());
        } else {
            super.applyEffectsFromBlocks();
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    public void setOnRails(boolean onRail) {
        this.onRails = onRail;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean yawFlipped) {
        this.flipped = yawFlipped;
    }

    public Vec3 getRedstoneDirection(BlockPos railPos) {
        BlockState iblockdata = this.level().getBlockState(railPos);
        if (iblockdata.is(Blocks.POWERED_RAIL) && iblockdata.getValue(PoweredRailBlock.POWERED).booleanValue()) {
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            if (blockpropertytrackposition == RailShape.EAST_WEST) {
                if (this.isRedstoneConductor(railPos.west())) {
                    return new Vec3(1.0, 0.0, 0.0);
                }
                if (this.isRedstoneConductor(railPos.east())) {
                    return new Vec3(-1.0, 0.0, 0.0);
                }
            } else if (blockpropertytrackposition == RailShape.NORTH_SOUTH) {
                if (this.isRedstoneConductor(railPos.north())) {
                    return new Vec3(0.0, 0.0, 1.0);
                }
                if (this.isRedstoneConductor(railPos.south())) {
                    return new Vec3(0.0, 0.0, -1.0);
                }
            }
            return Vec3.ZERO;
        }
        return Vec3.ZERO;
    }

    public boolean isRedstoneConductor(BlockPos pos) {
        return this.level().getBlockState(pos).isRedstoneConductor(this.level(), pos);
    }

    protected Vec3 applyNaturalSlowdown(Vec3 velocity) {
        double d0 = this.behavior.getSlowdownFactor();
        Vec3 vec3d1 = velocity.multiply(d0, 0.0, d0);
        if (this.isInWater()) {
            vec3d1 = vec3d1.scale(0.95f);
        }
        return vec3d1;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), nbt.getCompound("DisplayState")));
            this.setDisplayOffset(nbt.getInt("DisplayOffset"));
        }
        this.flipped = nbt.getBoolean("FlippedRotation");
        this.firstTick = nbt.getBoolean("HasTicked");
        if (nbt.contains("Paper.FrictionState")) {
            String fs = nbt.getString("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        if (this.hasCustomDisplay()) {
            nbt.putBoolean("CustomDisplayTile", true);
            nbt.put("DisplayState", NbtUtils.writeBlockState(this.getDisplayBlockState()));
            nbt.putInt("DisplayOffset", this.getDisplayOffset());
        }
        nbt.putBoolean("FlippedRotation", this.flipped);
        nbt.putBoolean("HasTicked", this.firstTick);
        if (this.frictionState != TriState.NOT_SET) {
            nbt.putString("Paper.FrictionState", this.frictionState.toString());
        }
    }

    @Override
    public void push(Entity entity) {
        if (!(this.level().isClientSide || entity.noPhysics || this.noPhysics)) {
            if (!this.level().paperConfig().collisions.allowVehicleCollisions && this.level().paperConfig().collisions.onlyPlayersCollide && !(entity instanceof Player)) {
                return;
            }
            if (!this.hasPassenger(entity)) {
                double d1;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) {
                    return;
                }
                double d0 = entity.getX() - this.getX();
                double d2 = d0 * d0 + (d1 = entity.getZ() - this.getZ()) * d1;
                if (d2 >= (double)1.0E-4f) {
                    d2 = Math.sqrt(d2);
                    d0 /= d2;
                    d1 /= d2;
                    double d3 = 1.0 / d2;
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    d0 *= d3;
                    d1 *= d3;
                    d0 *= (double)0.1f;
                    d1 *= (double)0.1f;
                    d0 *= 0.5;
                    d1 *= 0.5;
                    if (entity instanceof AbstractMinecart) {
                        AbstractMinecart entityminecartabstract = (AbstractMinecart)entity;
                        this.pushOtherMinecart(entityminecartabstract, d0, d1);
                    } else {
                        this.push(-d0, 0.0, -d1);
                        entity.push(d0 / 4.0, 0.0, d1 / 4.0);
                    }
                }
            }
        }
    }

    private void pushOtherMinecart(AbstractMinecart entity, double xDiff, double zDiff) {
        double d3;
        double d2;
        if (AbstractMinecart.useExperimentalMovement(this.level())) {
            d2 = this.getDeltaMovement().x;
            d3 = this.getDeltaMovement().z;
        } else {
            d2 = entity.getX() - this.getX();
            d3 = entity.getZ() - this.getZ();
        }
        Vec3 vec3d = new Vec3(d2, 0.0, d3).normalize();
        Vec3 vec3d1 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize();
        double d4 = Math.abs(vec3d.dot(vec3d1));
        if (d4 >= (double)0.8f || AbstractMinecart.useExperimentalMovement(this.level())) {
            Vec3 vec3d2 = this.getDeltaMovement();
            Vec3 vec3d3 = entity.getDeltaMovement();
            if (entity.isFurnace() && !this.isFurnace()) {
                this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                this.push(vec3d3.x - xDiff, 0.0, vec3d3.z - zDiff);
                entity.setDeltaMovement(vec3d3.multiply(0.95, 1.0, 0.95));
            } else if (!entity.isFurnace() && this.isFurnace()) {
                entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                entity.push(vec3d2.x + xDiff, 0.0, vec3d2.z + zDiff);
                this.setDeltaMovement(vec3d2.multiply(0.95, 1.0, 0.95));
            } else {
                double d5 = (vec3d3.x + vec3d2.x) / 2.0;
                double d6 = (vec3d3.z + vec3d2.z) / 2.0;
                this.setDeltaMovement(vec3d2.multiply(0.2, 1.0, 0.2));
                this.push(d5 - xDiff, 0.0, d6 - zDiff);
                entity.setDeltaMovement(vec3d3.multiply(0.2, 1.0, 0.2));
                entity.push(d5 + xDiff, 0.0, d6 + zDiff);
            }
        }
    }

    public BlockState getDisplayBlockState() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayBlockState() : Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        return !this.hasCustomDisplay() ? this.getDefaultDisplayOffset() : this.getEntityData().get(DATA_ID_DISPLAY_OFFSET).intValue();
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState state) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(state));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int offset) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, offset);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean present) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, present);
    }

    public static boolean useExperimentalMovement(Level world) {
        return world.enabledFeatures().contains(FeatureFlags.MINECART_IMPROVEMENTS);
    }

    @Override
    public abstract ItemStack getPickResult();

    public boolean isRideable() {
        return false;
    }

    public boolean isFurnace() {
        return false;
    }

    public Vector getFlyingVelocityMod() {
        return new Vector(this.flyingX, this.flyingY, this.flyingZ);
    }

    public void setFlyingVelocityMod(Vector flying) {
        this.flyingX = flying.getX();
        this.flyingY = flying.getY();
        this.flyingZ = flying.getZ();
    }

    public Vector getDerailedVelocityMod() {
        return new Vector(this.derailedX, this.derailedY, this.derailedZ);
    }

    public void setDerailedVelocityMod(Vector derailed) {
        this.derailedX = derailed.getX();
        this.derailedY = derailed.getY();
        this.derailedZ = derailed.getZ();
    }

    public Item publicGetDropItem() {
        return this.getDropItem();
    }
}

