/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MinecartFurnace
extends AbstractMinecart {
    private static final EntityDataAccessor<Boolean> DATA_ID_FUEL = SynchedEntityData.defineId(MinecartFurnace.class, EntityDataSerializers.BOOLEAN);
    private static final int FUEL_TICKS_PER_ITEM = 3600;
    private static final int MAX_FUEL_TICKS = 32000;
    public int fuel;
    public Vec3 push = Vec3.ZERO;

    public MinecartFurnace(EntityType<? extends MinecartFurnace> type, Level world) {
        super(type, world);
    }

    @Override
    @Override
    public boolean isFurnace() {
        return true;
    }

    @Override
    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_FUEL, false);
    }

    @Override
    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.fuel > 0) {
                --this.fuel;
            }
            if (this.fuel <= 0) {
                this.push = Vec3.ZERO;
            }
            this.setHasFuel(this.fuel > 0);
        }
        if (this.hasFuel() && this.random.nextInt(4) == 0) {
            this.level().addParticle(ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + 0.8, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Override
    protected double getMaxSpeed(ServerLevel world) {
        return this.isInWater() ? super.getMaxSpeed(world) * 0.75 : super.getMaxSpeed(world) * 0.5;
    }

    @Override
    @Override
    protected Item getDropItem() {
        return Items.FURNACE_MINECART;
    }

    @Override
    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.FURNACE_MINECART);
    }

    @Override
    @Override
    protected Vec3 applyNaturalSlowdown(Vec3 velocity) {
        Vec3 vec32;
        if (this.push.lengthSqr() > 1.0E-7) {
            this.push = this.calculateNewPushAlong(velocity);
            Vec3 vec3 = velocity.multiply(0.8, 0.0, 0.8).add(this.push);
            if (this.isInWater()) {
                vec3 = vec3.scale(0.1);
            }
        } else {
            vec32 = velocity.multiply(0.98, 0.0, 0.98);
        }
        return super.applyNaturalSlowdown(vec32);
    }

    private Vec3 calculateNewPushAlong(Vec3 velocity) {
        double d = 1.0E-4;
        double e = 0.001;
        if (this.push.horizontalDistanceSqr() > 1.0E-4 && velocity.horizontalDistanceSqr() > 0.001) {
            return this.push.projectedOn(velocity).normalize().scale(this.push.length());
        }
        return this.push;
    }

    @Override
    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(ItemTags.FURNACE_MINECART_FUEL) && this.fuel + 3600 <= 32000) {
            itemStack.consume(1, player);
            this.fuel += 3600;
        }
        if (this.fuel > 0) {
            this.push = this.position().subtract(player.position()).horizontal();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putDouble("PushX", this.push.x);
        nbt.putDouble("PushZ", this.push.z);
        nbt.putShort("Fuel", (short)this.fuel);
    }

    @Override
    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        double d = nbt.getDouble("PushX");
        double e = nbt.getDouble("PushZ");
        this.push = new Vec3(d, 0.0, e);
        this.fuel = nbt.getShort("Fuel");
    }

    protected boolean hasFuel() {
        return this.entityData.get(DATA_ID_FUEL);
    }

    protected void setHasFuel(boolean lit) {
        this.entityData.set(DATA_ID_FUEL, lit);
    }

    @Override
    @Override
    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)((BlockState)Blocks.FURNACE.defaultBlockState().setValue(AbstractFurnaceBlock.FACING, Direction.NORTH)).setValue(AbstractFurnaceBlock.LIT, this.hasFuel());
    }
}

