/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class OldMinecartBehavior
extends MinecartBehavior {
    private static final double MINECART_RIDABLE_THRESHOLD = 0.01;
    private static final double MAX_SPEED_IN_WATER = 0.2;
    private static final double MAX_SPEED_ON_LAND = 0.4;
    private static final double ABSOLUTE_MAX_SPEED = 0.4;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 targetDeltaMovement = Vec3.ZERO;

    public OldMinecartBehavior(AbstractMinecart minecart) {
        super(minecart);
    }

    @Override
    public void cancelLerp() {
        this.lerpSteps = 0;
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yaw;
        this.lerpXRot = pitch;
        this.lerpSteps = interpolationSteps + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.minecart.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.minecart.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.minecart.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpMotion(double x, double y, double z) {
        this.targetDeltaMovement = new Vec3(x, y, z);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public void tick() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            double d2;
            ServerLevel worldserver = (ServerLevel)world;
            this.minecart.applyGravity();
            BlockPos blockposition = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState iblockdata = this.level().getBlockState(blockposition);
            boolean flag = BaseRailBlock.isRail(iblockdata);
            this.minecart.setOnRails(flag);
            if (flag) {
                this.moveAlongTrack(worldserver);
                if (iblockdata.is(Blocks.ACTIVATOR_RAIL)) {
                    this.minecart.activateMinecart(blockposition.getX(), blockposition.getY(), blockposition.getZ(), iblockdata.getValue(PoweredRailBlock.POWERED));
                }
            } else {
                this.minecart.comeOffTrack(worldserver);
            }
            this.minecart.applyEffectsFromBlocks();
            this.setXRot(0.0f);
            double d0 = this.minecart.xo - this.getX();
            double d1 = this.minecart.zo - this.getZ();
            if (d0 * d0 + d1 * d1 > 0.001) {
                this.setYRot((float)(Mth.atan2(d1, d0) * 180.0 / Math.PI));
                if (this.minecart.isFlipped()) {
                    this.setYRot(this.getYRot() + 180.0f);
                }
            }
            if ((d2 = (double)Mth.wrapDegrees(this.getYRot() - this.minecart.yRotO)) < -170.0 || d2 >= 170.0) {
                this.setYRot(this.getYRot() + 180.0f);
                this.minecart.setFlipped(!this.minecart.isFlipped());
            }
            this.setXRot(this.getXRot() % 360.0f);
            this.setYRot(this.getYRot() % 360.0f);
            this.pushAndPickupEntities();
        } else if (this.lerpSteps > 0) {
            this.minecart.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            --this.lerpSteps;
        } else {
            this.minecart.reapplyPosition();
            this.setXRot(this.getXRot() % 360.0f);
            this.setYRot(this.getYRot() % 360.0f);
        }
    }

    @Override
    public void moveAlongTrack(ServerLevel world) {
        double d17;
        Vec3 vec3d5;
        double d16;
        double d15;
        double d14;
        Vec3 vec3d2;
        BlockPos blockposition = this.minecart.getCurrentBlockPosOrRailBelow();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        this.minecart.resetFallDistance();
        double d0 = this.minecart.getX();
        double d1 = this.minecart.getY();
        double d2 = this.minecart.getZ();
        Vec3 vec3d = this.getPos(d0, d1, d2);
        d1 = blockposition.getY();
        boolean flag = false;
        boolean flag1 = false;
        if (iblockdata.is(Blocks.POWERED_RAIL)) {
            flag = iblockdata.getValue(PoweredRailBlock.POWERED);
            flag1 = !flag;
        }
        double d3 = 0.0078125;
        if (this.minecart.isInWater()) {
            d3 *= 0.2;
        }
        Vec3 vec3d1 = this.getDeltaMovement();
        RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
        switch (blockpropertytrackposition) {
            case ASCENDING_EAST: {
                this.setDeltaMovement(vec3d1.add(-d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement(vec3d1.add(d3, 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, d3));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement(vec3d1.add(0.0, 0.0, -d3));
                d1 += 1.0;
            }
        }
        vec3d1 = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
        Vec3i baseblockposition = (Vec3i)pair.getFirst();
        Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
        double d4 = baseblockposition1.getX() - baseblockposition.getX();
        double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.x * d4 + vec3d1.z * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, vec3d1.horizontalDistance());
        vec3d1 = new Vec3(d8 * d4 / d6, vec3d1.y, d8 * d5 / d6);
        this.setDeltaMovement(vec3d1);
        Entity entity = this.minecart.getFirstPassenger();
        Entity entity1 = this.minecart.getFirstPassenger();
        if (entity1 instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity1;
            vec3d2 = entityplayer.getLastClientMoveIntent();
        } else {
            vec3d2 = Vec3.ZERO;
        }
        if (entity instanceof Player && vec3d2.lengthSqr() > 0.0) {
            Vec3 vec3d3 = vec3d2.normalize();
            double d9 = this.getDeltaMovement().horizontalDistanceSqr();
            if (vec3d3.lengthSqr() > 0.0 && d9 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add(vec3d2.x * 0.001, 0.0, vec3d2.z * 0.001));
                flag1 = false;
            }
        }
        if (flag1) {
            double d10 = this.getDeltaMovement().horizontalDistance();
            if (d10 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double d10 = (double)blockposition.getX() + 0.5 + (double)baseblockposition.getX() * 0.5;
        double d11 = (double)blockposition.getZ() + 0.5 + (double)baseblockposition.getZ() * 0.5;
        double d12 = (double)blockposition.getX() + 0.5 + (double)baseblockposition1.getX() * 0.5;
        double d13 = (double)blockposition.getZ() + 0.5 + (double)baseblockposition1.getZ() * 0.5;
        d4 = d12 - d10;
        d5 = d13 - d11;
        if (d4 == 0.0) {
            d14 = d2 - (double)blockposition.getZ();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)blockposition.getX();
        } else {
            d15 = d0 - d10;
            d16 = d2 - d11;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d10 + d4 * d14;
        d2 = d11 + d5 * d14;
        this.setPos(d0, d1, d2);
        d15 = this.minecart.isVehicle() ? 0.75 : 1.0;
        d16 = this.minecart.getMaxSpeed(world);
        vec3d1 = this.getDeltaMovement();
        this.minecart.move(MoverType.SELF, new Vec3(Mth.clamp(d15 * vec3d1.x, -d16, d16), 0.0, Mth.clamp(d15 * vec3d1.z, -d16, d16)));
        if (baseblockposition.getY() != 0 && Mth.floor(this.minecart.getX()) - blockposition.getX() == baseblockposition.getX() && Mth.floor(this.minecart.getZ()) - blockposition.getZ() == baseblockposition.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)baseblockposition.getY(), this.minecart.getZ());
        } else if (baseblockposition1.getY() != 0 && Mth.floor(this.minecart.getX()) - blockposition.getX() == baseblockposition1.getX() && Mth.floor(this.minecart.getZ()) - blockposition.getZ() == baseblockposition1.getZ()) {
            this.setPos(this.minecart.getX(), this.minecart.getY() + (double)baseblockposition1.getY(), this.minecart.getZ());
        }
        this.setDeltaMovement(this.minecart.applyNaturalSlowdown(this.getDeltaMovement()));
        Vec3 vec3d4 = this.getPos(this.minecart.getX(), this.minecart.getY(), this.minecart.getZ());
        if (vec3d4 != null && vec3d != null) {
            double d18 = (vec3d.y - vec3d4.y) * 0.05;
            vec3d5 = this.getDeltaMovement();
            d17 = vec3d5.horizontalDistance();
            if (d17 > 0.0) {
                this.setDeltaMovement(vec3d5.multiply((d17 + d18) / d17, 1.0, (d17 + d18) / d17));
            }
            this.setPos(this.minecart.getX(), vec3d4.y, this.minecart.getZ());
        }
        int i = Mth.floor(this.minecart.getX());
        int j = Mth.floor(this.minecart.getZ());
        if (i != blockposition.getX() || j != blockposition.getZ()) {
            vec3d5 = this.getDeltaMovement();
            d17 = vec3d5.horizontalDistance();
            this.setDeltaMovement(d17 * (double)(i - blockposition.getX()), vec3d5.y, d17 * (double)(j - blockposition.getZ()));
        }
        if (flag) {
            vec3d5 = this.getDeltaMovement();
            d17 = vec3d5.horizontalDistance();
            if (d17 > 0.01) {
                double d19 = world.purpurConfig.poweredRailBoostModifier;
                this.setDeltaMovement(vec3d5.add(vec3d5.x / d17 * world.purpurConfig.poweredRailBoostModifier, 0.0, vec3d5.z / d17 * world.purpurConfig.poweredRailBoostModifier));
            } else {
                Vec3 vec3d6 = this.getDeltaMovement();
                double d20 = vec3d6.x;
                double d21 = vec3d6.z;
                if (blockpropertytrackposition == RailShape.EAST_WEST) {
                    if (this.minecart.isRedstoneConductor(blockposition.west())) {
                        d20 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(blockposition.east())) {
                        d20 = -0.02;
                    }
                } else {
                    if (blockpropertytrackposition != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.minecart.isRedstoneConductor(blockposition.north())) {
                        d21 = 0.02;
                    } else if (this.minecart.isRedstoneConductor(blockposition.south())) {
                        d21 = -0.02;
                    }
                }
                this.setDeltaMovement(d20, vec3d6.y, d21);
            }
        }
    }

    @Nullable
    public Vec3 getPosOffs(double x, double y, double z, double d3) {
        BlockState iblockdata;
        int i = Mth.floor(x);
        int j = Mth.floor(y);
        int k = Mth.floor(z);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(iblockdata = this.level().getBlockState(new BlockPos(i, j, k)))) {
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            y = j;
            if (blockpropertytrackposition.isSlope()) {
                y = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
            Vec3i baseblockposition = (Vec3i)pair.getFirst();
            Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
            double d4 = baseblockposition1.getX() - baseblockposition.getX();
            double d5 = baseblockposition1.getZ() - baseblockposition.getZ();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (baseblockposition.getY() != 0 && Mth.floor(x += (d4 /= d6) * d3) - i == baseblockposition.getX() && Mth.floor(z += (d5 /= d6) * d3) - k == baseblockposition.getZ()) {
                y += (double)baseblockposition.getY();
            } else if (baseblockposition1.getY() != 0 && Mth.floor(x) - i == baseblockposition1.getX() && Mth.floor(z) - k == baseblockposition1.getZ()) {
                y += (double)baseblockposition1.getY();
            }
            return this.getPos(x, y, z);
        }
        return null;
    }

    @Nullable
    public Vec3 getPos(double x, double y, double z) {
        BlockState iblockdata;
        int i = Mth.floor(x);
        int j = Mth.floor(y);
        int k = Mth.floor(z);
        if (this.level().getBlockState(new BlockPos(i, j - 1, k)).is(BlockTags.RAILS)) {
            --j;
        }
        if (BaseRailBlock.isRail(iblockdata = this.level().getBlockState(new BlockPos(i, j, k)))) {
            double d12;
            RailShape blockpropertytrackposition = iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> pair = AbstractMinecart.exits(blockpropertytrackposition);
            Vec3i baseblockposition = (Vec3i)pair.getFirst();
            Vec3i baseblockposition1 = (Vec3i)pair.getSecond();
            double d3 = (double)i + 0.5 + (double)baseblockposition.getX() * 0.5;
            double d4 = (double)j + 0.0625 + (double)baseblockposition.getY() * 0.5;
            double d5 = (double)k + 0.5 + (double)baseblockposition.getZ() * 0.5;
            double d6 = (double)i + 0.5 + (double)baseblockposition1.getX() * 0.5;
            double d7 = (double)j + 0.0625 + (double)baseblockposition1.getY() * 0.5;
            double d8 = (double)k + 0.5 + (double)baseblockposition1.getZ() * 0.5;
            double d9 = d6 - d3;
            double d10 = (d7 - d4) * 2.0;
            double d11 = d8 - d5;
            if (d9 == 0.0) {
                d12 = z - (double)k;
            } else if (d11 == 0.0) {
                d12 = x - (double)i;
            } else {
                double d13 = x - d3;
                double d14 = z - d5;
                d12 = (d13 * d9 + d14 * d11) * 2.0;
            }
            x = d3 + d9 * d12;
            y = d4 + d10 * d12;
            z = d5 + d11 * d12;
            if (d10 < 0.0) {
                y += 1.0;
            } else if (d10 > 0.0) {
                y += 0.5;
            }
            return new Vec3(x, y, z);
        }
        return null;
    }

    @Override
    public double stepAlongTrack(BlockPos blockPos, RailShape railShape, double remainingMovement) {
        return 0.0;
    }

    @Override
    public boolean pushAndPickupEntities() {
        block5: {
            AABB axisalignedbb;
            block4: {
                axisalignedbb = this.minecart.getBoundingBox().inflate(0.2f, 0.0, 0.2f);
                if (!this.minecart.isRideable() || !(this.getDeltaMovement().horizontalDistanceSqr() >= 0.01)) break block4;
                List<Entity> list = this.level().getEntities(this.minecart, axisalignedbb, EntitySelector.pushableBy(this.minecart));
                if (list.isEmpty()) break block5;
                for (Entity entity : list) {
                    VehicleEntityCollisionEvent collisionEvent;
                    if (!(entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || this.minecart.isVehicle() || entity.isPassenger())) {
                        collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                        this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                        if (collisionEvent.isCancelled()) continue;
                        entity.startRiding(this.minecart);
                        continue;
                    }
                    if (!this.minecart.isPassengerOfSameVehicle(entity)) {
                        collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
                        this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                        if (collisionEvent.isCancelled()) continue;
                    }
                    entity.push(this.minecart);
                }
                break block5;
            }
            for (Entity entity1 : this.level().getEntities(this.minecart, axisalignedbb)) {
                if (this.minecart.hasPassenger(entity1) || !entity1.isPushable() || !(entity1 instanceof AbstractMinecart)) continue;
                VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)this.minecart.getBukkitEntity(), (org.bukkit.entity.Entity)entity1.getBukkitEntity());
                this.level().getCraftServer().getPluginManager().callEvent((Event)collisionEvent);
                if (collisionEvent.isCancelled()) continue;
                entity1.push(this.minecart);
            }
        }
        return false;
    }

    @Override
    public Direction getMotionDirection() {
        return this.minecart.isFlipped() ? this.minecart.getDirection().getOpposite().getClockWise() : this.minecart.getDirection().getClockWise();
    }

    @Override
    public Vec3 getKnownMovement(Vec3 velocity) {
        return new Vec3(Mth.clamp(velocity.x, -0.4, 0.4), velocity.y, Mth.clamp(velocity.z, -0.4, 0.4));
    }

    @Override
    public double getMaxSpeed(ServerLevel world) {
        Double maxSpeed = this.minecart.maxSpeed;
        if (maxSpeed != null) {
            return this.minecart.isInWater() ? maxSpeed / 2.0 : maxSpeed;
        }
        return this.minecart.isInWater() ? 0.2 : 0.4;
    }

    @Override
    public double getSlowdownFactor() {
        if (this.minecart.frictionState == TriState.FALSE) {
            return 1.0;
        }
        return this.minecart.isVehicle() || !this.minecart.slowWhenEmpty ? 0.997 : 0.96;
    }
}

