/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ResultSlot
extends Slot {
    private final CraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public ResultSlot(Player player, CraftingContainer input, Container inventory, int index, int x, int y) {
        super(inventory, index, x, y);
        this.player = player;
        this.craftSlots = input;
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    @Override
    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    @Override
    protected void onSwapCraft(int amount) {
        this.removeCount += amount;
    }

    @Override
    protected void checkTakeAchievements(ItemStack stack) {
        Container container;
        if (this.removeCount > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder recipeCraftingHolder = (RecipeCraftingHolder)((Object)container);
            recipeCraftingHolder.awardUsedRecipes(this.player, this.craftSlots.getItems());
        }
        this.removeCount = 0;
    }

    private static NonNullList<ItemStack> copyAllInputItems(CraftingInput input) {
        NonNullList<ItemStack> nonNullList = NonNullList.withSize(input.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonNullList.size(); ++i) {
            nonNullList.set(i, input.getItem(i));
        }
        return nonNullList;
    }

    private NonNullList<ItemStack> getRemainingItems(CraftingInput input, Level world) {
        NonNullList nonNullList;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            nonNullList = serverLevel.recipeAccess().getRecipeFor(RecipeType.CRAFTING, input, (Level)serverLevel, this.craftSlots.getCurrentRecipe()).map(recipe -> ((CraftingRecipe)recipe.value()).getRemainingItems(input)).orElseGet(() -> ResultSlot.copyAllInputItems(input));
        } else {
            nonNullList = CraftingRecipe.defaultCraftingReminder(input);
        }
        return nonNullList;
    }

    @Override
    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        CraftingInput.Positioned positioned = this.craftSlots.asPositionedCraftInput();
        CraftingInput craftingInput = positioned.input();
        int i = positioned.left();
        int j = positioned.top();
        NonNullList<ItemStack> nonNullList = this.getRemainingItems(craftingInput, player.level());
        for (int k = 0; k < craftingInput.height(); ++k) {
            for (int l = 0; l < craftingInput.width(); ++l) {
                int m = l + i + (k + j) * this.craftSlots.getWidth();
                ItemStack itemStack = this.craftSlots.getItem(m);
                ItemStack itemStack2 = nonNullList.get(l + k * craftingInput.width());
                if (!itemStack.isEmpty()) {
                    this.craftSlots.removeItem(m, 1);
                    itemStack = this.craftSlots.getItem(m);
                }
                if (itemStack2.isEmpty()) continue;
                if (itemStack.isEmpty()) {
                    this.craftSlots.setItem(m, itemStack2);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents(itemStack, itemStack2)) {
                    itemStack2.grow(itemStack.getCount());
                    this.craftSlots.setItem(m, itemStack2);
                    continue;
                }
                if (this.player.getInventory().add(itemStack2)) continue;
                this.player.drop(itemStack2, false);
            }
        }
    }

    @Override
    public boolean isFake() {
        return true;
    }
}

