/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerStonecutterRecipeSelectEvent;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.inventory.view.CraftStonecutterView;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.StonecutterInventory;
import org.bukkit.inventory.StonecuttingRecipe;

public class StonecutterMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final ContainerLevelAccess access;
    final DataSlot selectedRecipeIndex = DataSlot.shared(new int[1], 0);
    private final Level level;
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> recipesForInput = SelectableRecipe.SingleInputSet.empty();
    private ItemStack input = ItemStack.EMPTY;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container;
    final ResultContainer resultContainer;
    private CraftStonecutterView bukkitEntity = null;
    private org.bukkit.entity.Player player;

    @Override
    public CraftStonecutterView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.container, this.resultContainer);
        this.bukkitEntity = new CraftStonecutterView((HumanEntity)this.player, inventory, this);
        return this.bukkitEntity;
    }

    public StonecutterMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public StonecutterMenu(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(MenuType.STONECUTTER, syncId);
        this.container = new SimpleContainer(this.createBlockHolder(context), 1){

            @Override
            public void setChanged() {
                super.setChanged();
                StonecutterMenu.this.slotsChanged(this);
                StonecutterMenu.this.slotUpdateListener.run();
            }

            @Override
            public Location getLocation() {
                return context.getLocation();
            }
        };
        this.resultContainer = new ResultContainer(this.createBlockHolder(context));
        this.access = context;
        this.level = playerInventory.player.level();
        this.inputSlot = this.addSlot(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.addSlot(new Slot(this.resultContainer, 1, 143, 33){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            @Override
            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                StonecutterMenu.this.resultContainer.awardUsedRecipes(player, this.getRelevantItems());
                ItemStack itemstack1 = StonecutterMenu.this.inputSlot.remove(1);
                if (!itemstack1.isEmpty()) {
                    StonecutterMenu.this.setupResultSlot(StonecutterMenu.this.selectedRecipeIndex.get());
                }
                context.execute((world, blockposition) -> {
                    long j = world.getGameTime();
                    if (StonecutterMenu.this.lastSoundTime != j) {
                        world.playSound((Player)null, (BlockPos)blockposition, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        StonecutterMenu.this.lastSoundTime = j;
                    }
                });
                super.onTake(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                return List.of(StonecutterMenu.this.inputSlot.getItem());
            }
        });
        this.addStandardInventorySlots(playerInventory, 8, 84);
        this.addDataSlot(this.selectedRecipeIndex);
        this.player = (org.bukkit.entity.Player)playerInventory.player.getBukkitEntity();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getVisibleRecipes() {
        return this.recipesForInput;
    }

    public int getNumberOfVisibleRecipes() {
        return this.recipesForInput.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.hasItem() && !this.recipesForInput.isEmpty();
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return StonecutterMenu.stillValid(this.access, player, Blocks.STONECUTTER);
    }

    @Override
    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            Optional<RecipeHolder<StonecutterRecipe>> recipe;
            int recipeIndex = id;
            this.selectedRecipeIndex.set(recipeIndex);
            this.selectedRecipeIndex.checkAndClearUpdateFlag();
            if (this.isValidRecipeIndex(id) && !(recipe = this.recipesForInput.entries().get(id).recipe().recipe()).isEmpty()) {
                PlayerStonecutterRecipeSelectEvent event = new PlayerStonecutterRecipeSelectEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (StonecutterInventory)this.getBukkitView().getTopInventory(), (StonecuttingRecipe)recipe.get().toBukkitRecipe());
                if (!event.callEvent()) {
                    player.containerMenu.sendAllDataToRemote();
                    return false;
                }
                ResourceLocation key = CraftNamespacedKey.toMinecraft(event.getStonecuttingRecipe().getKey());
                if (!recipe.get().id().location().equals(key)) {
                    for (int newRecipeIndex = 0; newRecipeIndex < this.recipesForInput.entries().size(); ++newRecipeIndex) {
                        if (!this.recipesForInput.entries().get(newRecipeIndex).recipe().recipe().filter(r -> r.id().location().equals(key)).isPresent()) continue;
                        recipeIndex = newRecipeIndex;
                        break;
                    }
                }
            }
            player.containerMenu.sendAllDataToRemote();
            this.selectedRecipeIndex.set(recipeIndex);
            this.setupResultSlot(recipeIndex);
        }
        return true;
    }

    private boolean isValidRecipeIndex(int id) {
        return id >= 0 && id < this.recipesForInput.size();
    }

    @Override
    public void slotsChanged(Container inventory) {
        ItemStack itemstack = this.inputSlot.getItem();
        if (!itemstack.is(this.input.getItem())) {
            this.input = itemstack.copy();
            this.setupRecipeList(itemstack);
        }
        CraftEventFactory.callPrepareResultEvent(this, 1);
    }

    private void setupRecipeList(ItemStack stack) {
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        this.recipesForInput = !stack.isEmpty() ? this.level.recipeAccess().stonecutterRecipes().selectByInput(stack) : SelectableRecipe.SingleInputSet.empty();
    }

    void setupResultSlot(int selectedId) {
        Optional<RecipeHolder<Object>> optional;
        if (!this.recipesForInput.isEmpty() && this.isValidRecipeIndex(selectedId)) {
            SelectableRecipe.SingleInputEntry<StonecutterRecipe> selectablerecipe_a = this.recipesForInput.entries().get(selectedId);
            optional = selectablerecipe_a.recipe().recipe();
        } else {
            optional = Optional.empty();
        }
        optional.ifPresentOrElse(recipeholder -> {
            this.resultContainer.setRecipeUsed((RecipeHolder<?>)recipeholder);
            this.resultSlot.set(((StonecutterRecipe)recipeholder.value()).assemble(new SingleRecipeInput(this.container.getItem(0)), (HolderLookup.Provider)this.level.registryAccess()));
        }, () -> {
            this.resultSlot.set(ItemStack.EMPTY);
            this.resultContainer.setRecipeUsed(null);
        });
        this.broadcastChanges();
    }

    @Override
    public MenuType<?> getType() {
        return MenuType.STONECUTTER;
    }

    public void registerUpdateListener(Runnable contentsChangedListener) {
        this.slotUpdateListener = contentsChangedListener;
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultContainer && super.canTakeItemForPickAll(stack, slot);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot1 = this.slots.get(slot);
        if (slot1 != null && slot1.hasItem()) {
            ItemStack itemstack1 = slot1.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (slot == 1) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
                slot1.onQuickCraft(itemstack1, itemstack);
            } else if (slot == 0 ? !this.moveItemStackTo(itemstack1, 2, 38, false) : (this.level.recipeAccess().stonecutterRecipes().acceptsInput(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (slot >= 2 && slot < 29 ? !this.moveItemStackTo(itemstack1, 29, 38, false) : slot >= 29 && slot < 38 && !this.moveItemStackTo(itemstack1, 2, 29, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            }
            slot1.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot1.onTake(player, itemstack1);
            if (slot == 1) {
                player.drop(itemstack1, false);
            }
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(1);
        this.access.execute((world, blockposition) -> this.clearContainer(player, this.container));
    }
}

