/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class AdventureModePredicate {
    private static final Codec<AdventureModePredicate> SIMPLE_CODEC = BlockPredicate.CODEC.flatComapMap(predicate -> new AdventureModePredicate(List.of(predicate), true), checker -> DataResult.error(() -> "Cannot encode"));
    private static final Codec<AdventureModePredicate> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.nonEmptyList(BlockPredicate.CODEC.listOf()).fieldOf("predicates").forGetter(checker -> checker.predicates), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AdventureModePredicate::showInTooltip)).apply((Applicative)instance, AdventureModePredicate::new));
    public static final Codec<AdventureModePredicate> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(BlockPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), blockPredicatesChecker -> blockPredicatesChecker.predicates, ByteBufCodecs.BOOL, AdventureModePredicate::showInTooltip, AdventureModePredicate::new);
    public static final Component CAN_BREAK_HEADER = Component.translatable("item.canBreak").withStyle(ChatFormatting.GRAY);
    public static final Component CAN_PLACE_HEADER = Component.translatable("item.canPlace").withStyle(ChatFormatting.GRAY);
    private static final Component UNKNOWN_USE = Component.translatable("item.canUse.unknown").withStyle(ChatFormatting.GRAY);
    public final List<BlockPredicate> predicates;
    private final boolean showInTooltip;
    @Nullable
    private List<Component> cachedTooltip;
    @Nullable
    private BlockInWorld lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModePredicate(List<BlockPredicate> predicates, boolean showInTooltip) {
        this.predicates = predicates;
        this.showInTooltip = showInTooltip;
    }

    private static boolean areSameBlocks(BlockInWorld pos, @Nullable BlockInWorld cachedPos, boolean nbtAware) {
        if (cachedPos == null || pos.getState() != cachedPos.getState()) {
            return false;
        }
        if (!nbtAware) {
            return true;
        }
        if (pos.getEntity() == null && cachedPos.getEntity() == null) {
            return true;
        }
        if (pos.getEntity() == null || cachedPos.getEntity() == null) {
            return false;
        }
        RegistryAccess registryAccess = pos.getLevel().registryAccess();
        return Objects.equals(pos.getEntity().saveWithId(registryAccess), cachedPos.getEntity().saveWithId(registryAccess));
    }

    public boolean test(BlockInWorld cachedPos) {
        if (AdventureModePredicate.areSameBlocks(cachedPos, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = cachedPos;
        this.checksBlockEntity = false;
        for (BlockPredicate blockPredicate : this.predicates) {
            if (!blockPredicate.matches(cachedPos)) continue;
            this.checksBlockEntity |= blockPredicate.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    private List<Component> tooltip() {
        if (this.cachedTooltip == null) {
            this.cachedTooltip = AdventureModePredicate.computeTooltip(this.predicates);
        }
        return this.cachedTooltip;
    }

    public void addToTooltip(Consumer<Component> adder) {
        this.tooltip().forEach(adder);
    }

    public AdventureModePredicate withTooltip(boolean showInTooltip) {
        return new AdventureModePredicate(this.predicates, showInTooltip);
    }

    private static List<Component> computeTooltip(List<BlockPredicate> blockPredicates) {
        for (BlockPredicate blockPredicate : blockPredicates) {
            if (!blockPredicate.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return blockPredicates.stream().flatMap(predicate -> predicate.blocks().orElseThrow().stream()).distinct().map(holder -> ((Block)holder.value()).getName().withStyle(ChatFormatting.DARK_GRAY)).toList();
    }

    public boolean showInTooltip() {
        return this.showInTooltip;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AdventureModePredicate) {
            AdventureModePredicate adventureModePredicate = (AdventureModePredicate)object;
            return this.predicates.equals(adventureModePredicate.predicates) && this.showInTooltip == adventureModePredicate.showInTooltip;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.predicates.hashCode() * 31 + (this.showInTooltip ? 1 : 0);
    }

    @Override
    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + ", showInTooltip=" + this.showInTooltip + "}";
    }
}

