/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int MAX_SHOWN_GRID_ITEMS_X = 4;
    public static final int MAX_SHOWN_GRID_ITEMS_Y = 3;
    public static final int MAX_SHOWN_GRID_ITEMS = 12;
    public static final int OVERFLOWING_MAX_SHOWN_GRID_ITEMS = 11;
    private static final int FULL_BAR_COLOR = ARGB.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int BAR_COLOR = ARGB.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int TICKS_AFTER_FIRST_THROW = 10;
    private static final int TICKS_BETWEEN_THROWS = 2;
    private static final int TICKS_MAX_THROW_DURATION = 200;
    private final ResourceLocation openFrontModel;
    private final ResourceLocation openBackModel;

    public BundleItem(ResourceLocation openFrontTexture, ResourceLocation openBackTexture, Item.Properties settings) {
        super(settings);
        this.openFrontModel = openFrontTexture;
        this.openBackModel = openBackTexture;
    }

    public static float getFullnessDisplay(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.weight().floatValue();
    }

    public ResourceLocation openFrontModel() {
        return this.openFrontModel;
    }

    public ResourceLocation openBackModel() {
        return this.openBackModel;
    }

    @Override
    @Override
    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickType, Player player) {
        BundleContents bundleContents = stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null) {
            return false;
        }
        ItemStack itemStack = slot.getItem();
        BundleContents.Mutable mutable = new BundleContents.Mutable(bundleContents);
        if (clickType == ClickAction.PRIMARY && !itemStack.isEmpty()) {
            if (mutable.tryTransfer(slot, player) > 0) {
                BundleItem.playInsertSound(player);
            } else {
                BundleItem.playInsertFailSound(player);
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        if (clickType == ClickAction.SECONDARY && itemStack.isEmpty()) {
            ItemStack itemStack2 = mutable.removeOne();
            if (itemStack2 != null) {
                ItemStack itemStack3 = slot.safeInsert(itemStack2);
                if (itemStack3.getCount() > 0) {
                    mutable.tryInsert(itemStack3);
                } else {
                    BundleItem.playRemoveOneSound(player);
                }
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (clickType == ClickAction.PRIMARY && otherStack.isEmpty()) {
            BundleItem.toggleSelectedItem(stack, -1);
            return false;
        }
        BundleContents bundleContents = stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null) {
            return false;
        }
        BundleContents.Mutable mutable = new BundleContents.Mutable(bundleContents);
        if (clickType == ClickAction.PRIMARY && !otherStack.isEmpty()) {
            if (slot.allowModification(player) && mutable.tryInsert(otherStack) > 0) {
                BundleItem.playInsertSound(player);
            } else {
                BundleItem.playInsertFailSound(player);
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        if (clickType == ClickAction.SECONDARY && otherStack.isEmpty()) {
            ItemStack itemStack;
            if (slot.allowModification(player) && (itemStack = mutable.removeOne()) != null) {
                BundleItem.playRemoveOneSound(player);
                cursorStackReference.set(itemStack);
            }
            stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(player);
            return true;
        }
        BundleItem.toggleSelectedItem(stack, -1);
        return false;
    }

    @Override
    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide) {
            return InteractionResult.CONSUME;
        }
        user.startUsingItem(hand);
        return InteractionResult.SUCCESS_SERVER;
    }

    private void dropContent(Level world, Player player, ItemStack stack) {
        if (this.dropContent(stack, player)) {
            BundleItem.playDropContentsSound(world, player);
            player.awardStat(Stats.ITEM_USED.get(this));
        }
    }

    @Override
    @Override
    public boolean isBarVisible(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    @Override
    public int getBarWidth(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate(bundleContents.weight(), 12), 13);
    }

    @Override
    @Override
    public int getBarColor(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.weight().compareTo(Fraction.ONE) >= 0 ? FULL_BAR_COLOR : BAR_COLOR;
    }

    public static void toggleSelectedItem(ItemStack stack, int selectedStackIndex) {
        BundleContents bundleContents = stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null) {
            return;
        }
        BundleContents.Mutable mutable = new BundleContents.Mutable(bundleContents);
        mutable.toggleSelectedItem(selectedStackIndex);
        stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
    }

    public static boolean hasSelectedItem(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.getSelectedItem() != -1;
    }

    public static int getSelectedItem(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.getItemUnsafe(bundleContents.getSelectedItem());
    }

    public static int getNumberOfItemsToShow(ItemStack stack) {
        BundleContents bundleContents = stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundleContents.getNumberOfItemsToShow();
    }

    private boolean dropContent(ItemStack stack, Player player) {
        BundleContents bundleContents = stack.get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null || bundleContents.isEmpty()) {
            return false;
        }
        Optional<ItemStack> optional = BundleItem.removeOneItemFromBundle(stack, player, bundleContents);
        if (optional.isPresent()) {
            player.drop(optional.get(), true);
            return true;
        }
        return false;
    }

    private static Optional<ItemStack> removeOneItemFromBundle(ItemStack stack, Player player, BundleContents contents) {
        BundleContents.Mutable mutable = new BundleContents.Mutable(contents);
        ItemStack itemStack = mutable.removeOne();
        if (itemStack != null) {
            BundleItem.playRemoveOneSound(player);
            stack.set(DataComponents.BUNDLE_CONTENTS, mutable.toImmutable());
            return Optional.of(itemStack);
        }
        return Optional.empty();
    }

    @Override
    @Override
    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide && user instanceof Player) {
            boolean bl;
            Player player = (Player)user;
            int i = this.getUseDuration(stack, user);
            boolean bl2 = bl = remainingUseTicks == i;
            if (bl || remainingUseTicks < i - 10 && remainingUseTicks % 2 == 0) {
                this.dropContent(world, player, stack);
            }
        }
    }

    @Override
    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 200;
    }

    @Override
    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (stack.has(DataComponents.HIDE_TOOLTIP) || stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable(stack.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    @Override
    public void onDestroyed(ItemEntity entity) {
        BundleContents bundleContents = entity.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (bundleContents == null) {
            return;
        }
        entity.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemUtils.onContainerDestroyed(entity, bundleContents.itemsCopy());
    }

    public static List<BundleItem> getAllBundleItemColors() {
        return Stream.of(Items.BUNDLE, Items.WHITE_BUNDLE, Items.ORANGE_BUNDLE, Items.MAGENTA_BUNDLE, Items.LIGHT_BLUE_BUNDLE, Items.YELLOW_BUNDLE, Items.LIME_BUNDLE, Items.PINK_BUNDLE, Items.GRAY_BUNDLE, Items.LIGHT_GRAY_BUNDLE, Items.CYAN_BUNDLE, Items.BLACK_BUNDLE, Items.BROWN_BUNDLE, Items.GREEN_BUNDLE, Items.RED_BUNDLE, Items.BLUE_BUNDLE, Items.PURPLE_BUNDLE).map(item -> (BundleItem)item).toList();
    }

    public static Item getByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_BUNDLE;
            case DyeColor.ORANGE -> Items.ORANGE_BUNDLE;
            case DyeColor.MAGENTA -> Items.MAGENTA_BUNDLE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_BUNDLE;
            case DyeColor.YELLOW -> Items.YELLOW_BUNDLE;
            case DyeColor.LIME -> Items.LIME_BUNDLE;
            case DyeColor.PINK -> Items.PINK_BUNDLE;
            case DyeColor.GRAY -> Items.GRAY_BUNDLE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_BUNDLE;
            case DyeColor.CYAN -> Items.CYAN_BUNDLE;
            case DyeColor.BLUE -> Items.BLUE_BUNDLE;
            case DyeColor.BROWN -> Items.BROWN_BUNDLE;
            case DyeColor.GREEN -> Items.GREEN_BUNDLE;
            case DyeColor.RED -> Items.RED_BUNDLE;
            case DyeColor.BLACK -> Items.BLACK_BUNDLE;
            case DyeColor.PURPLE -> Items.PURPLE_BUNDLE;
        };
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(Level world, Entity entity) {
        world.playSound(null, entity.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void broadcastChangesOnContainerMenu(Player user) {
        AbstractContainerMenu abstractContainerMenu = user.containerMenu;
        if (abstractContainerMenu != null) {
            abstractContainerMenu.slotsChanged(user.getInventory());
        }
    }
}

