/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Projectile;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = context.getItemInHand();
            Vec3 vec3 = context.getClickLocation();
            Direction direction = context.getClickedFace();
            Projectile.Delayed<FireworkRocketEntity> fireworkRocketEntity = net.minecraft.world.entity.projectile.Projectile.spawnProjectileDelayed(new FireworkRocketEntity(level, context.getPlayer(), vec3.x + (double)direction.getStepX() * 0.15, vec3.y + (double)direction.getStepY() * 0.15, vec3.z + (double)direction.getStepZ() * 0.15, itemStack), serverLevel, itemStack, f -> {
                f.spawningEntity = context.getPlayer() == null ? null : context.getPlayer().getUUID();
            });
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)context.getPlayer().getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemStack), (Projectile)((Firework)fireworkRocketEntity.projectile().getBukkitEntity()));
            if (!event.callEvent() || !fireworkRocketEntity.attemptSpawn()) {
                return InteractionResult.PASS;
            }
            if (event.shouldConsume() && !context.getPlayer().hasInfiniteMaterials()) {
                itemStack.shrink(1);
            } else if (context.getPlayer() instanceof ServerPlayer) {
                ((ServerPlayer)context.getPlayer()).getBukkitEntity().updateInventory();
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        if (user.isFallFlying()) {
            ItemStack itemStack = user.getItemInHand(hand);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                Projectile.Delayed<FireworkRocketEntity> delayed = net.minecraft.world.entity.projectile.Projectile.spawnProjectileDelayed(new FireworkRocketEntity(world, itemStack, user), serverLevel, itemStack, f -> {
                    f.spawningEntity = user.getUUID();
                });
                PlayerElytraBoostEvent event = new PlayerElytraBoostEvent((org.bukkit.entity.Player)user.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemStack), (Firework)delayed.projectile().getBukkitEntity(), CraftEquipmentSlot.getHand(hand));
                if (event.callEvent() && delayed.attemptSpawn()) {
                    user.awardStat(Stats.ITEM_USED.get(this));
                    if (world.purpurConfig.elytraDamagePerFireworkBoost > 0) {
                        List<EquipmentSlot> list = EquipmentSlot.VALUES.stream().filter(enumitemslot -> LivingEntity.canGlideUsing(user.getItemBySlot((EquipmentSlot)enumitemslot), enumitemslot)).toList();
                        EquipmentSlot enumitemslot2 = Util.getRandom(list, user.random);
                        ItemStack glideItem = user.getItemBySlot(enumitemslot2);
                        if (user.canGlide()) {
                            glideItem.hurtAndBreak(world.purpurConfig.elytraDamagePerFireworkBoost, user, enumitemslot2);
                        }
                    }
                    if (event.shouldConsume() && !user.hasInfiniteMaterials()) {
                        itemStack.shrink(1);
                    } else {
                        ((ServerPlayer)user).getBukkitEntity().updateInventory();
                    }
                } else {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Fireworks fireworks = stack.get(DataComponents.FIREWORKS);
        if (fireworks != null) {
            fireworks.addToTooltip(context, tooltip::add, type);
        }
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        return new FireworkRocketEntity(world, stack.copyWithCount(1), pos.x(), pos.y(), pos.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityJustOutsideOfBlockPos(BlockSource pointer, Direction facing) {
        return pointer.center().add((double)facing.getStepX() * 0.5000099999997474, (double)facing.getStepY() * 0.5000099999997474, (double)facing.getStepZ() * 0.5000099999997474);
    }
}

