/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> type, Item.Properties settings) {
        super(settings);
        this.type = type;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        HangingEntity object;
        BlockPos blockposition = context.getClickedPos();
        Direction enumdirection = context.getClickedFace();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        Player entityhuman = context.getPlayer();
        ItemStack itemstack = context.getItemInHand();
        if (entityhuman != null && !this.mayPlace(entityhuman, enumdirection, itemstack, blockposition1)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> optional = Painting.create(world, blockposition1, enumdirection);
            if (optional.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            object = optional.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            object = new ItemFrame(world, blockposition1, enumdirection);
        } else {
            if (this.type != EntityType.GLOW_ITEM_FRAME) {
                return InteractionResult.SUCCESS;
            }
            object = new GlowItemFrame(world, blockposition1, enumdirection);
        }
        CustomData customdata = itemstack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!customdata.isEmpty()) {
            EntityType.updateCustomEntityTag(world, entityhuman, object, customdata);
            if (!world.purpurConfig.persistentDroppableEntityDisplayNames) {
                ((Entity)object).setCustomName(null);
            }
        }
        if (((HangingEntity)object).survives()) {
            if (!world.isClientSide) {
                org.bukkit.entity.Player who = context.getPlayer() == null ? null : (org.bukkit.entity.Player)context.getPlayer().getBukkitEntity();
                Block blockClicked = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                BlockFace blockFace = CraftBlock.notchToBlockFace(enumdirection);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(context.getHand());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)((HangingEntity)object).getBukkitEntity(), who, blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return InteractionResult.FAIL;
                }
                ((HangingEntity)object).playPlacementSound();
                world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, ((HangingEntity)object).position());
                world.addFreshEntity(object);
            }
            itemstack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player player, Direction side, ItemStack stack, BlockPos pos) {
        return !side.getAxis().isVertical() && player.mayUseItemAt(pos, side, stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        HolderLookup.Provider holderlookup_a = context.registries();
        if (holderlookup_a != null && this.type == EntityType.PAINTING) {
            CustomData customdata = stack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
            if (!customdata.isEmpty()) {
                customdata.read((DynamicOps<Tag>)holderlookup_a.createSerializationContext(NbtOps.INSTANCE), Painting.VARIANT_MAP_CODEC).result().ifPresentOrElse(holder -> {
                    Optional<Component> optional = ((PaintingVariant)holder.value()).title();
                    Objects.requireNonNull(tooltip);
                    optional.ifPresent(tooltip::add);
                    optional = ((PaintingVariant)holder.value()).author();
                    Objects.requireNonNull(tooltip);
                    optional.ifPresent(tooltip::add);
                    tooltip.add(Component.translatable("painting.dimensions", ((PaintingVariant)holder.value()).width(), ((PaintingVariant)holder.value()).height()));
                }, () -> tooltip.add(TOOLTIP_RANDOM_VARIANT));
            } else if (type.isCreative()) {
                tooltip.add(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

