/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MaceItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final float DEFAULT_ATTACK_SPEED = -3.4f;
    public static final float SMASH_ATTACK_FALL_THRESHOLD = 1.5f;
    private static final float SMASH_ATTACK_HEAVY_THRESHOLD = 5.0f;
    public static final float SMASH_ATTACK_KNOCKBACK_RADIUS = 3.5f;
    private static final float SMASH_ATTACK_KNOCKBACK_POWER = 0.7f;

    public MaceItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -3.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    @Override
    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.isCreative();
    }

    @Override
    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (MaceItem.canSmashAttack(attacker)) {
            ServerLevel serverLevel = (ServerLevel)attacker.level();
            attacker.setDeltaMovement(attacker.getDeltaMovement().with(Direction.Axis.Y, 0.01f));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)attacker;
                serverPlayer.currentImpulseImpactPos = this.calculateImpactPosition(serverPlayer);
                serverPlayer.setIgnoreFallDamageFromCurrentImpulse(true);
                serverPlayer.connection.send(new ClientboundSetEntityMotionPacket(serverPlayer));
            }
            if (target.onGround()) {
                if (attacker instanceof ServerPlayer) {
                    ServerPlayer serverPlayer2 = (ServerPlayer)attacker;
                    serverPlayer2.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent soundEvent = attacker.fallDistance > 5.0f ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverLevel.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), soundEvent, attacker.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverLevel.playSound(null, attacker.getX(), attacker.getY(), attacker.getZ(), SoundEvents.MACE_SMASH_AIR, attacker.getSoundSource(), 1.0f, 1.0f);
            }
            MaceItem.knockback(serverLevel, attacker, target);
        }
        return true;
    }

    private Vec3 calculateImpactPosition(ServerPlayer player) {
        if (player.isIgnoringFallDamageFromCurrentImpulse() && player.currentImpulseImpactPos != null && player.currentImpulseImpactPos.y <= player.position().y) {
            return player.currentImpulseImpactPos;
        }
        return player.position();
    }

    @Override
    @Override
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (MaceItem.canSmashAttack(attacker)) {
            attacker.resetFallDistance();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Override
    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        float k;
        void livingEntity2;
        Entity entity = damageSource.getDirectEntity();
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!MaceItem.canSmashAttack((LivingEntity)livingEntity2)) {
            return 0.0f;
        }
        float f = 3.0f;
        float g = 8.0f;
        float h = livingEntity2.fallDistance;
        if (h <= 3.0f) {
            float i = 4.0f * h;
        } else if (h <= 8.0f) {
            float j = 12.0f + 2.0f * (h - 3.0f);
        } else {
            k = 22.0f + h - 8.0f;
        }
        Level level = livingEntity2.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return k + EnchantmentHelper.modifyFallBasedDamage(serverLevel, livingEntity2.getWeaponItem(), target, damageSource, 0.0f) * h;
        }
        return k;
    }

    private static void knockback(Level world, Entity attacker, Entity attacked) {
        world.levelEvent(2013, attacked.getOnPos(), 750);
        world.getEntitiesOfClass(LivingEntity.class, attacked.getBoundingBox().inflate(3.5), MaceItem.knockbackPredicate(attacker, attacked)).forEach(entity -> {
            Vec3 vec3 = entity.position().subtract(attacked.position());
            double d = MaceItem.getKnockbackPower(attacker, entity, vec3);
            Vec3 vec32 = vec3.normalize().scale(d);
            if (d > 0.0) {
                entity.push(vec32.x, 0.7f, vec32.z);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.connection.send(new ClientboundSetEntityMotionPacket(serverPlayer));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Entity attacker, Entity attacked) {
        return entity -> {
            ArmorStand armorStand;
            TamableAnimal tamableAnimal;
            boolean bl = !entity.isSpectator();
            boolean bl2 = entity != attacker && entity != attacked;
            boolean bl3 = !attacker.isAlliedTo((Entity)entity);
            boolean bl4 = !(entity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).isTame() && attacker.getUUID().equals(tamableAnimal.getOwnerUUID()));
            boolean bl5 = !(entity instanceof ArmorStand) || !(armorStand = (ArmorStand)entity).isMarker();
            boolean bl6 = attacked.distanceToSqr((Entity)entity) <= Math.pow(3.5, 2.0);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        };
    }

    private static double getKnockbackPower(Entity attacker, LivingEntity attacked, Vec3 distance) {
        return (3.5 - distance.length()) * (double)0.7f * (double)(attacker.fallDistance > 5.0f ? 2 : 1) * (1.0 - attacked.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity attacker) {
        return attacker.fallDistance > 1.5f && !attacker.isFallFlying();
    }

    @Override
    @Nullable
    @Override
    public DamageSource getDamageSource(LivingEntity user) {
        if (MaceItem.canSmashAttack(user)) {
            return user.damageSources().mace(user);
        }
        return super.getDamageSource(user);
    }
}

