/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class MinecartItem
extends Item {
    private final EntityType<? extends AbstractMinecart> type;

    public MinecartItem(EntityType<? extends AbstractMinecart> type, Item.Properties settings) {
        super(settings);
        this.type = type;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockposition;
        Level world = context.getLevel();
        BlockState iblockdata = world.getBlockState(blockposition = context.getClickedPos());
        if (!iblockdata.is(BlockTags.RAILS)) {
            if (!world.purpurConfig.minecartPlaceAnywhere) {
                return InteractionResult.FAIL;
            }
            if (iblockdata.isSolid()) {
                blockposition = blockposition.relative(context.getClickedFace());
            }
        }
        ItemStack itemstack = context.getItemInHand();
        RailShape blockpropertytrackposition = iblockdata.getBlock() instanceof BaseRailBlock ? iblockdata.getValue(((BaseRailBlock)iblockdata.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
        double d0 = 0.0;
        if (blockpropertytrackposition.isSlope()) {
            d0 = 0.5;
        }
        Vec3 vec3d = new Vec3((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.0625 + d0, (double)blockposition.getZ() + 0.5);
        AbstractMinecart entityminecartabstract = AbstractMinecart.createMinecart(world, vec3d.x, vec3d.y, vec3d.z, this.type, EntitySpawnReason.DISPENSER, itemstack, context.getPlayer());
        if (entityminecartabstract == null) {
            return InteractionResult.FAIL;
        }
        if (AbstractMinecart.useExperimentalMovement(world)) {
            List<Entity> list = world.getEntities(null, entityminecartabstract.getBoundingBox());
            for (Entity entity : list) {
                if (!(entity instanceof AbstractMinecart)) continue;
                return InteractionResult.FAIL;
            }
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (CraftEventFactory.callEntityPlaceEvent(context, entityminecartabstract).isCancelled()) {
                if (context.getPlayer() != null) {
                    context.getPlayer().containerMenu.sendAllDataToRemote();
                }
                return InteractionResult.FAIL;
            }
            if (!worldserver.addFreshEntity(entityminecartabstract)) {
                return InteractionResult.PASS;
            }
            worldserver.gameEvent(GameEvent.ENTITY_PLACE, blockposition, GameEvent.Context.of(context.getPlayer(), worldserver.getBlockState(blockposition.below())));
        }
        itemstack.shrink(1);
        return InteractionResult.SUCCESS;
    }
}

