/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import io.papermc.paper.event.player.PlayerItemCooldownEvent;
import io.papermc.paper.event.player.PlayerItemGroupCooldownEvent;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Player;

public class ServerItemCooldowns
extends ItemCooldowns {
    private final ServerPlayer player;

    public ServerItemCooldowns(ServerPlayer player) {
        this.player = player;
    }

    @Override
    public void addCooldown(ItemStack item, int duration) {
        ResourceLocation cooldownGroup = this.getCooldownGroup(item);
        PlayerItemCooldownEvent event = new PlayerItemCooldownEvent((Player)this.player.getBukkitEntity(), CraftItemType.minecraftToBukkit(item.getItem()), CraftNamespacedKey.fromMinecraft(cooldownGroup), duration);
        if (event.callEvent()) {
            super.addCooldown(cooldownGroup, event.getCooldown(), false);
        }
    }

    @Override
    public void addCooldown(ResourceLocation groupId, int duration, boolean callEvent) {
        if (callEvent) {
            PlayerItemGroupCooldownEvent event = new PlayerItemGroupCooldownEvent((Player)this.player.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(groupId), duration);
            if (!event.callEvent()) {
                return;
            }
            duration = event.getCooldown();
        }
        super.addCooldown(groupId, duration, false);
    }

    @Override
    protected void onCooldownStarted(ResourceLocation groupId, int duration) {
        super.onCooldownStarted(groupId, duration);
        this.player.connection.send(new ClientboundCooldownPacket(groupId, duration));
    }

    @Override
    protected void onCooldownEnded(ResourceLocation groupId) {
        super.onCooldownEnded(groupId);
        this.player.connection.send(new ClientboundCooldownPacket(groupId, 0));
    }
}

