/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Projectile;

public class SnowballItem
extends Item
implements ProjectileItem {
    public SnowballItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Projectile.Delayed<Snowball> snowball = net.minecraft.world.entity.projectile.Projectile.spawnProjectileFromRotationDelayed(Snowball::new, worldserver, itemstack, user, 0.0f, 1.5f, (float)worldserver.purpurConfig.snowballProjectileOffset);
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)user.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemstack), (Projectile)snowball.projectile().getBukkitEntity());
            if (event.callEvent() && snowball.attemptSpawn()) {
                user.awardStat(Stats.ITEM_USED.get(this));
                if (event.shouldConsume()) {
                    itemstack.consume(1, user);
                } else if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                world.playSound((Player)null, user.getX(), user.getY(), user.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            } else {
                if (user instanceof ServerPlayer) {
                    ((ServerPlayer)user).getBukkitEntity().updateInventory();
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        return new Snowball(world, pos.x(), pos.y(), pos.z(), stack);
    }
}

