/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.TrialSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.purpurmc.purpur.event.PlayerSetSpawnerTypeWithEggEvent;
import org.purpurmc.purpur.event.PlayerSetTrialSpawnerTypeWithEggEvent;

public class SpawnEggItem
extends Item {
    private static final Map<net.minecraft.world.entity.EntityType<? extends Mob>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();
    private static final MapCodec<net.minecraft.world.entity.EntityType<?>> ENTITY_TYPE_FIELD_CODEC = BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("id");
    private final int backgroundColor;
    private final int highlightColor;
    private final net.minecraft.world.entity.EntityType<?> defaultType;

    public SpawnEggItem(net.minecraft.world.entity.EntityType<? extends Mob> type, int primaryColor, int secondaryColor, Item.Properties settings) {
        super(settings);
        this.defaultType = type;
        this.backgroundColor = primaryColor;
        this.highlightColor = secondaryColor;
        BY_ID.put(type, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockposition = context.getClickedPos();
        Direction enumdirection = context.getClickedFace();
        BlockState iblockdata = world.getBlockState(blockposition);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof Spawner) {
            if (world.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return InteractionResult.FAIL;
            }
            Spawner spawner = (Spawner)((Object)tileentity);
            net.minecraft.world.entity.EntityType<?> entitytypes = this.getType(itemstack);
            if (spawner instanceof SpawnerBlockEntity) {
                Block bukkitBlock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                PlayerSetSpawnerTypeWithEggEvent event = new PlayerSetSpawnerTypeWithEggEvent((org.bukkit.entity.Player)context.getPlayer().getBukkitEntity(), bukkitBlock, (CreatureSpawner)bukkitBlock.getState(), EntityType.fromName((String)entitytypes.getName()));
                if (!event.callEvent()) {
                    return InteractionResult.FAIL;
                }
                entitytypes = net.minecraft.world.entity.EntityType.getFromBukkitType(event.getEntityType());
            } else if (spawner instanceof TrialSpawnerBlockEntity) {
                Block bukkitBlock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                PlayerSetTrialSpawnerTypeWithEggEvent event = new PlayerSetTrialSpawnerTypeWithEggEvent((org.bukkit.entity.Player)context.getPlayer().getBukkitEntity(), bukkitBlock, (TrialSpawner)bukkitBlock.getState(), EntityType.fromName((String)entitytypes.getName()));
                if (!event.callEvent()) {
                    return InteractionResult.FAIL;
                }
                entitytypes = net.minecraft.world.entity.EntityType.getFromBukkitType(event.getEntityType());
            }
            spawner.setEntityId(entitytypes, world.getRandom());
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            world.gameEvent((Entity)context.getPlayer(), GameEvent.BLOCK_CHANGE, blockposition);
            itemstack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockposition1 = iblockdata.getCollisionShape(world, blockposition).isEmpty() ? blockposition : blockposition.relative(enumdirection);
        net.minecraft.world.entity.EntityType<?> entitytypes = this.getType(itemstack);
        if (entitytypes.spawn((ServerLevel)world, itemstack, context.getPlayer(), blockposition1, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(blockposition, blockposition1) && enumdirection == Direction.UP) != null) {
            itemstack.shrink(1);
            world.gameEvent((Entity)context.getPlayer(), GameEvent.ENTITY_PLACE, blockposition);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        BlockHitResult movingobjectpositionblock = SpawnEggItem.getPlayerPOVHitResult(world, user, ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionblock.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockposition = movingobjectpositionblock.getBlockPos();
        if (!(world.getBlockState(blockposition).getBlock() instanceof LiquidBlock)) {
            return InteractionResult.PASS;
        }
        if (world.mayInteract(user, blockposition) && user.mayUseItemAt(blockposition, movingobjectpositionblock.getDirection(), itemstack)) {
            net.minecraft.world.entity.EntityType<?> entitytypes = this.getType(itemstack);
            Object entity = entitytypes.spawn((ServerLevel)world, itemstack, user, blockposition, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
            if (entity == null) {
                return InteractionResult.PASS;
            }
            itemstack.consume(1, user);
            user.awardStat(Stats.ITEM_USED.get(this));
            world.gameEvent((Entity)user, GameEvent.ENTITY_PLACE, ((Entity)entity).position());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean spawnsEntity(ItemStack stack, net.minecraft.world.entity.EntityType<?> type) {
        return Objects.equals(this.getType(stack), type);
    }

    public int getColor(int tintIndex) {
        return tintIndex == 0 ? this.backgroundColor : this.highlightColor;
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable net.minecraft.world.entity.EntityType<?> type) {
        return BY_ID.get(type);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public net.minecraft.world.entity.EntityType<?> getType(ItemStack stack) {
        CustomData customdata = stack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        return !customdata.isEmpty() ? customdata.read(ENTITY_TYPE_FIELD_CODEC).result().orElse(this.defaultType) : this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player user, Mob entity, net.minecraft.world.entity.EntityType<? extends Mob> entityType, ServerLevel world, Vec3 pos, ItemStack stack) {
        if (!this.spawnsEntity(stack, entityType)) {
            return Optional.empty();
        }
        Mob object = entity instanceof AgeableMob ? ((AgeableMob)entity).getBreedOffspring(world, (AgeableMob)entity) : entityType.create(world, EntitySpawnReason.SPAWN_ITEM_USE);
        if (object == null) {
            return Optional.empty();
        }
        object.setBaby(true);
        if (!object.isBaby()) {
            return Optional.empty();
        }
        object.moveTo(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
        world.addFreshEntityWithPassengers(object, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        object.setCustomName(stack.get(DataComponents.CUSTOM_NAME));
        stack.consume(1, user);
        return Optional.of(object);
    }
}

