/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties settings) {
        super(settings);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2);
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.isCreative();
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.SPEAR;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    @Override
    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player entityhuman = (Player)user;
            int j = this.getUseDuration(stack, user) - remainingUseTicks;
            if (j < 10) {
                return false;
            }
            float f = EnchantmentHelper.getTridentSpinAttackStrength(stack, entityhuman);
            if (f > 0.0f && !entityhuman.isInWaterOrRain()) {
                return false;
            }
            if (stack.nextDamageWillBreak()) {
                return false;
            }
            Holder<SoundEvent> holder = EnchantmentHelper.pickHighestLevel(stack, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (f == 0.0f) {
                    Projectile.Delayed<ThrownTrident> tridentDelayed = Projectile.spawnProjectileFromRotationDelayed(ThrownTrident::new, worldserver, stack, entityhuman, 0.0f, 2.5f, (float)worldserver.purpurConfig.tridentProjectileOffset);
                    PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(stack), (org.bukkit.entity.Projectile)tridentDelayed.projectile().getBukkitEntity());
                    if (!event.callEvent() || !tridentDelayed.attemptSpawn()) {
                        if (entityhuman instanceof ServerPlayer) {
                            ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                        }
                        return false;
                    }
                    ThrownTrident entitythrowntrident = tridentDelayed.projectile();
                    entitythrowntrident.setActualEnchantments(stack.getEnchantments());
                    if (event.shouldConsume()) {
                        stack.hurtWithoutBreaking(1, entityhuman);
                    }
                    entitythrowntrident.pickupItemStack = stack.copy();
                    if (entityhuman.hasInfiniteMaterials()) {
                        entitythrowntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else if (event.shouldConsume()) {
                        entityhuman.getInventory().removeItem(stack);
                    }
                    world.playSound((Player)null, entitythrowntrident, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
                stack.hurtWithoutBreaking(1, entityhuman);
            }
            entityhuman.awardStat(Stats.ITEM_USED.get(this));
            if (f > 0.0f) {
                EquipmentSlot enumitemslot2;
                ItemStack glideItem;
                float f1 = entityhuman.getYRot();
                float f2 = entityhuman.getXRot();
                float f3 = -Mth.sin(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                float f4 = -Mth.sin(f2 * ((float)Math.PI / 180));
                float f5 = Mth.cos(f1 * ((float)Math.PI / 180)) * Mth.cos(f2 * ((float)Math.PI / 180));
                float f6 = Mth.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
                CraftEventFactory.callPlayerRiptideEvent(entityhuman, stack, f3 *= f / f6, f4 *= f / f6, f5 *= f / f6);
                List<EquipmentSlot> list = EquipmentSlot.VALUES.stream().filter(enumitemslot -> LivingEntity.canGlideUsing(entityhuman.getItemBySlot((EquipmentSlot)enumitemslot), enumitemslot)).toList();
                if (!list.isEmpty() && (glideItem = entityhuman.getItemBySlot(enumitemslot2 = Util.getRandom(list, entityhuman.random))).has(DataComponents.GLIDER) && world.purpurConfig.elytraDamagePerTridentBoost > 0) {
                    glideItem.hurtAndBreak(world.purpurConfig.elytraDamagePerTridentBoost, entityhuman, enumitemslot2);
                }
                entityhuman.push(f3, f4, f5);
                entityhuman.startAutoSpinAttack(20, 8.0f, stack);
                if (entityhuman.onGround()) {
                    float f7 = 1.1999999f;
                    entityhuman.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                world.playSound((Player)null, entityhuman, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemstack = user.getItemInHand(hand);
        if (itemstack.nextDamageWillBreak()) {
            return InteractionResult.FAIL;
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength(itemstack, user) > 0.0f && !user.isInWaterOrRain()) {
            return InteractionResult.FAIL;
        }
        user.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    @Override
    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    @Override
    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        ThrownTrident entitythrowntrident = new ThrownTrident(world, pos.x(), pos.y(), pos.z(), stack.copyWithCount(1));
        entitythrowntrident.pickup = AbstractArrow.Pickup.ALLOWED;
        return entitythrowntrident;
    }
}

