/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class BannerDuplicateRecipe
extends CustomRecipe {
    public BannerDuplicateRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @Override
    public boolean matches(CraftingInput input, Level world) {
        if (input.ingredientCount() != 2) {
            return false;
        }
        DyeColor dyeColor = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty()) continue;
            Item item = itemStack.getItem();
            if (item instanceof BannerItem) {
                BannerItem bannerItem = (BannerItem)item;
                if (dyeColor == null) {
                    dyeColor = bannerItem.getColor();
                } else if (dyeColor != bannerItem.getColor()) {
                    return false;
                }
            } else {
                return false;
            }
            int j = itemStack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size();
            if (j > 6) {
                return false;
            }
            if (j > 0) {
                if (bl2) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl2 && bl;
    }

    @Override
    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (int i = 0; i < input.size(); ++i) {
            int j;
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty() || (j = itemStack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().size()) <= 0 || j > 6) continue;
            return itemStack.copyWithCount(1);
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList<ItemStack> nonNullList = NonNullList.withSize(input.size(), ItemStack.EMPTY);
        for (int i = 0; i < nonNullList.size(); ++i) {
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty()) continue;
            ItemStack itemStack2 = itemStack.getItem().getCraftingRemainder();
            if (!itemStack2.isEmpty()) {
                nonNullList.set(i, itemStack2);
                continue;
            }
            if (itemStack.getOrDefault(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY).layers().isEmpty()) continue;
            nonNullList.set(i, itemStack.copyWithCount(1));
        }
        return nonNullList;
    }

    @Override
    @Override
    public RecipeSerializer<BannerDuplicateRecipe> getSerializer() {
        return RecipeSerializer.BANNER_DUPLICATE;
    }
}

