/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeMap {
    public static final RecipeMap EMPTY = new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Map.of());
    public final Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    public final Map<ResourceKey<Recipe<?>>, RecipeHolder<?>> byKey;

    private RecipeMap(Multimap<RecipeType<?>, RecipeHolder<?>> byType, Map<ResourceKey<Recipe<?>>, RecipeHolder<?>> byKey) {
        this.byType = byType;
        this.byKey = byKey;
    }

    public static RecipeMap create(Iterable<RecipeHolder<?>> recipes) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : recipes) {
            builder.put(recipeholder.value().getType(), recipeholder);
            com_google_common_collect_immutablemap_builder.put(recipeholder.id(), recipeholder);
        }
        return new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)LinkedHashMultimap.create((Multimap)builder.build()), Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build()));
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        Collection map = this.byType.get(irecipe.value().getType());
        if (this.byKey.containsKey(irecipe.id())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.id()));
        }
        map.add(irecipe);
        this.byKey.put(irecipe.id(), irecipe);
    }

    public <T extends RecipeInput> boolean removeRecipe(ResourceKey<Recipe<T>> mcKey) {
        RecipeHolder<?> remove = this.byKey.remove(mcKey);
        if (remove == null) {
            return false;
        }
        Collection recipes = this.byType(remove.value().getType());
        return recipes.remove(remove);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> type) {
        return this.byType.get(type);
    }

    public Collection<RecipeHolder<?>> values() {
        return this.byKey.values();
    }

    @Nullable
    public RecipeHolder<?> byKey(ResourceKey<Recipe<?>> key) {
        return this.byKey.get(key);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getRecipesFor(RecipeType<T> type, I input, Level world) {
        return input.isEmpty() ? Stream.empty() : this.byType(type).stream().filter(recipeholder -> recipeholder.value().matches((RecipeInput)input, world));
    }
}

