/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Nullable
    private static Pair<ItemStack, ItemStack> getItemsToCombine(CraftingInput craftingInput) {
        if (craftingInput.ingredientCount() != 2) {
            return null;
        }
        ItemStack itemStack = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack2 = craftingInput.getItem(i);
            if (itemStack2.isEmpty()) continue;
            if (itemStack == null) {
                itemStack = itemStack2;
                continue;
            }
            return RepairItemRecipe.canCombine(itemStack, itemStack2) ? Pair.of((Object)itemStack, (Object)itemStack2) : null;
        }
        return null;
    }

    private static boolean canCombine(ItemStack first, ItemStack second) {
        return second.is(first.getItem()) && first.getCount() == 1 && second.getCount() == 1 && first.has(DataComponents.MAX_DAMAGE) && second.has(DataComponents.MAX_DAMAGE) && first.has(DataComponents.DAMAGE) && second.has(DataComponents.DAMAGE);
    }

    @Override
    @Override
    public boolean matches(CraftingInput input, Level world) {
        return RepairItemRecipe.getItemsToCombine(input) != null;
    }

    @Override
    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        Pair<ItemStack, ItemStack> pair = RepairItemRecipe.getItemsToCombine(input);
        if (pair == null) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = (ItemStack)pair.getFirst();
        ItemStack itemStack2 = (ItemStack)pair.getSecond();
        int i = Math.max(itemStack.getMaxDamage(), itemStack2.getMaxDamage());
        int j = itemStack.getMaxDamage() - itemStack.getDamageValue();
        int k = itemStack2.getMaxDamage() - itemStack2.getDamageValue();
        int l = j + k + i * 5 / 100;
        ItemStack itemStack3 = new ItemStack(itemStack.getItem());
        itemStack3.set(DataComponents.MAX_DAMAGE, i);
        itemStack3.setDamageValue(Math.max(i - l, 0));
        ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting(itemStack);
        ItemEnchantments itemEnchantments2 = EnchantmentHelper.getEnchantmentsForCrafting(itemStack2);
        EnchantmentHelper.updateEnchantments(itemStack3, builder -> registries.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter(enchantment -> enchantment.is(EnchantmentTags.CURSE)).forEach(enchantment -> {
            int i = Math.max(itemEnchantments.getLevel((Holder<Enchantment>)enchantment), itemEnchantments2.getLevel((Holder<Enchantment>)enchantment));
            if (i > 0) {
                builder.upgrade((Holder<Enchantment>)enchantment, i);
            }
        }));
        return itemStack3;
    }

    @Override
    @Override
    public RecipeSerializer<RepairItemRecipe> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

