/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TippedArrowRecipe
extends CustomRecipe {
    public TippedArrowRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @Override
    public boolean matches(CraftingInput input, Level world) {
        if (input.width() != 3 || input.height() != 3 || input.ingredientCount() != 9) {
            return false;
        }
        for (int i = 0; i < input.height(); ++i) {
            for (int j = 0; j < input.width(); ++j) {
                ItemStack itemStack = input.getItem(j, i);
                if (itemStack.isEmpty()) {
                    return false;
                }
                if (!(j == 1 && i == 1 ? !itemStack.is(Items.LINGERING_POTION) : !itemStack.is(Items.ARROW))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack itemStack = input.getItem(1, 1);
        if (!itemStack.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack2 = new ItemStack(Items.TIPPED_ARROW, 8);
        itemStack2.set(DataComponents.POTION_CONTENTS, itemStack.get(DataComponents.POTION_CONTENTS));
        return itemStack2;
    }

    @Override
    @Override
    public RecipeSerializer<TippedArrowRecipe> getSerializer() {
        return RecipeSerializer.TIPPED_ARROW;
    }
}

